/*****************************************************************************
 *  Reset Button Utilities Menu
 *
 *  FILE: reset_button_menu.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>

#if defined(CFG_RARITAN_UTIL_RESET_BUTTON)

#include <reset_button_menu.h>
#include <reset_button.h>
#include <util.h>


static void print_reset_button_menu( void )
{
    printf("\nReset Button Utility:");
    print_exit();
    printf("\n\t 1: Get Status");
    printf("\n\n");

    return;
}

int reset_button_menu( void )
{
    char reset_button_flag = 1;
    int result = 1;
    unsigned long diag_opt;
    int opt_res;
    int status;

    while (reset_button_flag) {
        print_reset_button_menu();

        opt_res = menu_get_user_input(&diag_opt);
        if( opt_res > 0 ) {
            return 0;
        }
        else if( opt_res < 0 ) {
            continue;
        }

        switch( diag_opt ) {
            case RESET_BUTTON_MENU_EXIT:
                reset_button_flag = 0;
                break;

            case RESET_BUTTON_MENU_STATUS:
                status = reset_button_get_status();
                printf("\nReset Button is %s pressed\n", status?"not":"\b");
                break;

            default:
                print_invalid();
                break;
        }
    }

    return result;
}

#endif /* (CFG_RARITAN_UTIL_RESET_BUTTON) */
