/*****************************************************************************
 *  RS485 header file
 *
 *  FILE: rs485.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _RS485_H_
#define _RS485_H_

#define RS485_BAUD_RATE          9600

#define RS485_GPIO7              0x01000000

#define RS485_TIMEOUT_NOLIMIT    0xFFFFFFFF

extern int rs485_serial_init(void);
extern void rs485_serial_setbrg(void);
extern int  rs485_serial_putc(const char c);
extern void rs485_serial_puts(const char *s);
extern int rs485_serial_getc(char *byte, unsigned long timeout);
extern int rs485_serial_tstc(void);
extern int rs485_loopback_test(void);

#endif /* _RS485_H_ */
