/*****************************************************************************
 *  RS485 Utilities Menu
 *
 *  FILE: rs485_menu.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>

#if defined(CFG_RARITAN_UTIL_RS485)

#include <rs485.h>
#include <rs485_menu.h>
#include <util.h>


static void print_rs485_menu( void )
{
    printf("\nRS485 Utility:");
    print_exit();
    printf("\n\t 1: Send Byte");
    printf("\n\t 2: Receive Byte");
    printf("\n\t 3: Test Loopback");
    printf("\n\n");

    return;
}

int rs485_menu( void )
{
    char rs485_flag = 1;
    int result = 1; /* result is used for reverting back to U-boot cmds */
    unsigned long diag_opt;
    int opt_res;
    int nchars;
    int err;
    char rxbyte, txbyte;
    unsigned long val;

    /* initialize RS485 */
    rs485_serial_init();

    while (rs485_flag) {
        print_rs485_menu();

        opt_res = menu_get_user_input(&diag_opt);
        if( opt_res > 0 ) {
            return 0;
        }
        else if( opt_res < 0 ) {
            continue;
        }

        switch( diag_opt ) {
            case RS485_MENU_EXIT:
                rs485_flag = 0;
                break;

            case RS485_MENU_TX_BYTE:
                nchars = print_prompt("\nEnter BYTE to send: 0x", &val, 16);
                if (nchars > 0) {
                    txbyte = val & 0xff;
                    err = rs485_serial_putc(txbyte);
                    if (err == -2) {
                        printf("\nTest Halted\n");
                    }
                }
                break;

            case RS485_MENU_RX_BYTE:
                err = rs485_serial_getc(&rxbyte, RS485_TIMEOUT_NOLIMIT);
                if (err == 0) {
                    printf("\nReceive 0x%x byte\n", rxbyte);
                }
                else if (err == -2) {
                    printf("\nTest Halted\n");
                }
                break;

            case RS485_MENU_TEST_LPBK:
                printf("\nTesting RS485 Loopback.........");
                if (rs485_loopback_test() == 0) {
                    printf("passed.\n");
                }
                break;

            default:
                print_invalid();
                break;
        }
    }

    return result;
}

#endif /* CFG_RARITAN_UTIL_RS485 */
