/*****************************************************************************
 *  Speaker Utilities Menu
 *
 *  FILE: speaker_menu.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>

#if defined(CFG_RARITAN_UTIL_SPEAKER)

#include <speaker_menu.h>
#include <speaker.h>
#include <util.h>


static void print_speaker_menu( void )
{
    printf("\nSpeaker Utility:");
    print_exit();
    printf("\n\t 1: Speaker On");
    printf("\n\t 2: Speaker Off");
    printf("\n\n");

    return;
}

int speaker_menu( void )
{
    char speaker_flag = 1;
    int result = 1;
    unsigned long diag_opt;
    unsigned short freq = 587;
    int opt_res;

    while (speaker_flag) {
        print_speaker_menu();

        opt_res = menu_get_user_input(&diag_opt);
        if( opt_res > 0 ) {
            return 0;
        }
        else if( opt_res < 0 ) {
            continue;
        }

        switch( diag_opt ) {
            case SPEAKER_MENU_EXIT:
                speaker_flag = 0;
                break;

            case SPEAKER_MENU_TURN_ON:
                speaker_on(freq);
                break;

            case SPEAKER_MENU_TURN_OFF:
                speaker_off();
                break;

            default:
                print_invalid();
                break;
        }
    }

    return result;
}

#endif /* (CFG_RARITAN_UTIL_SPEAKER) */
