/*****************************************************************************
 *  Utility routines
 *
 *  FILE: util.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>
#include <util.h>

#define TIKRATE              256000

#define is_digit(c)	((c) >= '0' && (c) <= '9')


/*-----------------------------------------------------------------------------
 * void dotik(rate,use_ret)
 *
 * PARAMETERS:
 *  rate     controls how fast the display rotates. The larger the value,
 *           the faster the rotation.
 *
 *  use_ret  specifies that " %c\r" should be used rather than "\b%c".
 *---------------------------------------------------------------------------*/
void dotik( int rate, int use_ret )
{
   static int tik_cnt;
   char more_tiks[] = "|/-\\";
   static char *more_tik = 0;

   tik_cnt -= rate;
   if (tik_cnt > 0) return;
   tik_cnt = TIKRATE;
   if (more_tik == 0) more_tik = more_tiks;
   if (*more_tik == 0) more_tik = more_tiks;
   if (use_ret) printf(" %c\r",*more_tik);
   else printf("\b%c",*more_tik);
   more_tik++;

   return;
}

/*-----------------------------------------------------------------------------
 * Print a prompt and get the value entered by user if applicable
 *---------------------------------------------------------------------------*/
int print_prompt( char *prompt, ulong *var, int base )
{
    int num_chars;
    num_chars = readline(prompt);
    if (num_chars > 0 && var) {
       *var = simple_strtoul(console_buffer, NULL, base);
    }
    return num_chars;
}

/*-----------------------------------------------------------------------------
 * Similar to print_prompt but will check for non-numerical values as well
 *---------------------------------------------------------------------------*/
int get_diagopts( char *prompt, ulong *pdiag )
{
    int num_chars;
    num_chars = readline(prompt);

    if (num_chars <= 0) {
       return -1;
    }
    else if (num_chars > 2) {
       return -2;
    }

    if (console_buffer[0] == 'U') {
       return 1;
    }
    else if (!is_digit(console_buffer[0])
             || (num_chars == 2 && !is_digit(console_buffer[1]))) {
       return -2;
    }
    *pdiag = simple_strtoul(console_buffer, NULL, 10);

    return 0;
}

/*-----------------------------------------------------------------------------
 * Generic Invalid printout
 *---------------------------------------------------------------------------*/
void print_invalid( void )
{
    printf("\nInvalid Option Specified!\n");
    return;
}

/*-----------------------------------------------------------------------------
 * Generic unimplemented printout
 *---------------------------------------------------------------------------*/
void print_not_implemented( void )
{
    printf("\nNot yet implemented!\n");
    return;
}

/*-----------------------------------------------------------------------------
 * Generic exit printout
 *---------------------------------------------------------------------------*/
void print_exit( void )
{
    printf("\n=============================");
    printf("\n\t 0: Exit");
    return;
}

/*-----------------------------------------------------------------------------
 * Generic not set printout
 *---------------------------------------------------------------------------*/
void print_not_set( void )
{
    printf("NOT SET");
    return;
}

/*-----------------------------------------------------------------------------
 * Pause printout
 *---------------------------------------------------------------------------*/
int print_pause( void )
{
    int nchars;

    nchars = readline("\n\nHit ENTER key to continue...");

    return nchars;
}

/*-----------------------------------------------------------------------------
 * User input retrieval using menu
 *---------------------------------------------------------------------------*/
int menu_get_user_input( unsigned long *diag_opt )
{
    int opt_res;

    opt_res = get_diagopts("Please choose: ", diag_opt);
    if( opt_res > 0 ) {
        printf("\nReverting back to U-BOOT commands\n\n");
    }
    else if( opt_res < -1 ) {
        print_invalid();
    }

    return opt_res;
}

/*-----------------------------------------------------------------------------
 * Flash Device Sector Protection Enable
 *---------------------------------------------------------------------------*/
void flash_protect_on( int bank, int start_sector, int end_sector )
{
    /* info for FLASH chips */
    extern flash_info_t flash_info[];

    flash_protect(FLAG_PROTECT_SET, flash_info[bank].start[start_sector],
                  flash_info[bank].start[end_sector], &flash_info[bank]);
    return;
}

/*-----------------------------------------------------------------------------
 * Flash Device Sector Protection Disable
 *---------------------------------------------------------------------------*/
void flash_protect_off( int bank, int start_sector, int end_sector )
{
    /* info for FLASH chips */
    extern flash_info_t flash_info[];

    flash_protect(FLAG_PROTECT_CLEAR, flash_info[bank].start[start_sector],
                  flash_info[bank].start[end_sector], &flash_info[bank]);
    return;
}
