/*****************************************************************************
 *  X1226 RTC header file
 *
 *  FILE: x1226.h
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _X1226_H_
#define _X1226_H_

#include <rtc.h>

/* X1226 i2c address */
#define CFG_I2C_RTC_ADDR       0x6F

/* Register offset */
#define X1226_RTC_BASE         0x30
#define X1226_SC               0x30
#define X1226_MN               0x31
#define X1226_HR               0x32
#define X1226_DT               0x33
#define X1226_MO               0x34
#define X1226_YR               0x35
#define X1226_DW               0x36
#define X1226_Y2K              0x37

#define X1226_SR               0x3F

/* Control */
#define X1226_DTR              0x13
#define X1226_ATR              0x12
#define X1226_INT              0x11
#define X1226_BL               0x10

/* Alarm1 */
#define X1226_Y2K1             0x0F
#define X1226_DWA1             0x0E
#define X1226_YRA1             0x0D
#define X1226_MOA1             0x0C
#define X1226_DTA1             0x0B
#define X1226_HRA1             0x0A
#define X1226_MNA1             0x09
#define X1226_SCA1             0x08

/* Alarm0 */
#define X1226_Y2K0             0x07
#define X1226_DWA0             0x06
#define X1226_YRA0             0x05
#define X1226_MOA0             0x04
#define X1226_DTA0             0x03
#define X1226_HRA0             0x02
#define X1226_MNA0             0x01
#define X1226_SCA0             0x00

/* relevant RTC registers without the supervisory functions */
#define X1226_RTC_REG_CNT      8

/* RTC register count */
#define REG_CNT                0x3F

/* relevant bits */
#define SECONDS_RBITS          0x7F
#define MINUTES_RBITS          0x7F
#define HOURS_RBITS            0x3F
#define DAY_RBITS              0x07
#define DATE_RBITS             0x3F
#define MONTH_RBITS            0x1F

/* Status bits */
#define X1226_SR_RTCF          0x01
#define X1226_SR_WEL           0x02
#define X1226_SR_RWEL          0x04
#define X1226_SR_AL0           0x40
#define X1226_SR_AL1           0x20
#define X1226_SR_BAT           0x80

/* Hour format indication bit (1 - 24-hour format, 0 - 12-hour format) */
#define X1226_HR_MIL           0x80

extern void  rtc_init( void );
extern int   rtc_check_regaddr( uchar reg );
extern uchar rtc_read( uchar reg );
extern void  rtc_write( uchar reg, uchar val );
extern void  rtc_read_all( uchar *data );
extern void  rtc_print( uchar reg, uchar val );

#endif /* _X1226_H_ */
