/*****************************************************************************
 *  Raritan KX2.0 Flash Partition Header
 *
 *  FILE: flash_partition.h
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _FLASH_PARTITION_H_
#define _FLASH_PARTITION_H_

#define FLASH_SECTOR_SIZE        (128 << 10)               /* 0x00020000 */
#define FLASH_PARAMETER_SIZE     (32 << 10)                /* 0x00008000 */

/*
 * +======================================================================+
 * | This should be the same file in KX2.0 bootloader, the Linux kernel,  |
 * | and kx2.0-romify application.                                        |
 * +======================================================================+
 *
 * Image offsets and sizes corresponds to the address given below.
 * This is based on the mtd partitions in the linux kernel.
 * If the mtd partitions changes, then this has to be updated as well.
 *
 *
 *      0xFC000000   ---------------------------
 *                   |          JFFS2          |
 *                   |   63.75MB [0x03FC0000]  |
 *      0xFFFFC000   ---------------------------
 *                   |  U-BOOT W/ ENVIRONMENT  |
 *                   |    256KB  [0x00040000]  |
 *                   ---------------------------
 *
 */
#define JFFS2_IMAGE_SIZE         ((64 << 20) - (CFG_MONITOR_LEN))
#define UBOOT_IMAGE_SIZE         CFG_MONITOR_LEN

#define JFFS2_IMAGE_OFFSET       0x00000000
#define UBOOT_IMAGE_OFFSET       (JFFS2_IMAGE_OFFSET + JFFS2_IMAGE_SIZE)

#ifndef USE_KX101_KIM_ON_WINGLE
#define UBOOT_FLASH_BANK         1
#define UBOOT_SECTOR_END         258
#define UBOOT_SECTOR_START       (UBOOT_SECTOR_END + 1 - (UBOOT_IMAGE_SIZE / (1024 * 128)))
#else
#define UBOOT_FLASH_BANK         0
#define UBOOT_SECTOR_START       126
#define UBOOT_SECTOR_END         127
#endif

#endif /* _FLASH_PARTITION_H_ */
