/******************************************************************************
 *
 * Hardware configuration of KIM 1.1 / MB "B52"
 *
 * Hardware-ID: 0x18
 *
 */  

#ifndef _HW_18_H
#define _HW_18_H

/* ----------------------------------------------------------------------------
 * Miscellaneous Hardware Configuration
 */

#define PP_HWID_18_CPU_TYPE		PP_CPU_405GPR	/* The CPU type */
#define PP_HWID_18_FLASH_SIZE		(64*1024*1024)	/* Flash size in bytes */
#define PP_HWID_18_SDRAM_ROWS		4096		/* SDRAM row count */
#define PP_HWID_18_SDRAM_B0CR		0x000A4001	/* 128MB @ 0x0 13x10x4 */
#if 1
#define PP_HWID_18_SDRAM_RTR		0x0408		/* 133 MHz; 64ms; 4k refresh */
#define PP_HWID_18_SDRAM_TR		0x01098016	/* 133 MHz; CASL=3, PTA=3, CTP=2, LDF=3, RFTA=9, RCD=3 */
#else
#define PP_HWID_18_SDRAM_RTR		0x0618		/* 133 MHz; 64ms; 4k refresh */
#define PP_HWID_18_SDRAM_TR		0x010FC01B	/* 133 MHz; CASL=3, PTA=4, CTP=4, LDF=4, RFTA=10, RCD=4 */
#endif
#define PP_HWID_18_SYS_CLK_FREQ		33333333	/* external frequency to PLL */
#define PP_HWID_18_PHY_LED_CFG_VALUE	0x0472		/* LXT972A; register 0x14 */
#define PP_HWID_18_BIGPHYSAREA_PAGES	1026		/* # of reserved pages for linux */
#define PP_HWID_18_CONSOLE              PP_SERIAL_0

#define PP_HWID_18_DESCRIPTION		"KIM 1.2 / FPGA C4"

/* ----------------------------------------------------------------------------
 * The PLL configuration (see PPC405EP manual section 7.2, 7.5.3 and 7.5.4)
 */

#define PP_HWID_18_DYNAMIC_PLL	   0

#if PP_HWID_18_CPU_TYPE == PP_CPU_405EP
/* ------------- 33 MHz SysClk Settings --------------- */
/* Slow (66 MHz CPU-Clk, 33MHz bus) */
#define PP_HWID_18_PLLMR0_SLOW (PLL_CPUDIV_2		\
				   | PLL_PLBDIV_1	\
				   | PLL_OPBDIV_2	\
				   | PLL_EXTBUSDIV_2	\
				   | PLL_MALDIV_1	\
				   | PLL_PCIDIV_4)

#define PP_HWID_18_PLLMR1_SLOW (PLL_FBKDIV_6		\
				   | PLL_FWDDIVA_4	\
				   | PLL_FWDDIVB_4	\
				   | PLL_TUNE_15_M_40	\
				   | PLL_TUNE_VCO_LOW)

/* Fast (200 MHz CPU-Clk, 50 MHz bus) */
# define PP_HWID_18_PLLMR0_FAST (PLL_CPUDIV_1		\
				   | PLL_PLBDIV_2	\
				   | PLL_OPBDIV_2	\
				   | PLL_EXTBUSDIV_2	\
				   | PLL_MALDIV_1	\
				   | PLL_PCIDIV_3)


#define PP_HWID_18_PLLMR1_FAST (PLL_FBKDIV_6		\
				   | PLL_FWDDIVA_4	\
				   | PLL_FWDDIVB_4	\
				   | PLL_TUNE_15_M_40	\
				   | PLL_TUNE_VCO_LOW)
					
#define PP_HWID_18_PLLMR0_DEFAULT	PP_HWID_18_PLLMR0_FAST
#define PP_HWID_18_PLLMR1_DEFAULT	PP_HWID_18_PLLMR1_FAST
#else /* PP_HWID_18_CPU_TYPE == PP_CPU_405EP*/
#endif /* PP_HWID_18_CPU_TYPE == PP_CPU_405EP*/

/* ----------------------------------------------------------------------------
 * GPIO configuration
 */

/* GPIO 0: Unused */
#define PP_HWID_18_GPIO_00_IS_OUTPUT		0
#define PP_HWID_18_GPIO_00_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_00_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_00_IS_GPIO		0

/* GPIO 1: PPC pin strapping - unused config as input */
#define PP_HWID_18_GPIO_01_IS_OUTPUT		0
#define PP_HWID_18_GPIO_01_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_01_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_01_IS_GPIO		1

/* GPIO 2: PPC pin strapping - unused config as input */
#define PP_HWID_18_GPIO_02_IS_OUTPUT		0
#define PP_HWID_18_GPIO_02_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_02_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_02_IS_GPIO		PP_HWID_18_GPIO_01_IS_GPIO

/* GPIO 3: Buzzer control - output 0 */
#define PP_HWID_18_GPIO_03_IS_OUTPUT		1
#define PP_HWID_18_GPIO_03_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_03_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_03_IS_GPIO		PP_HWID_18_GPIO_01_IS_GPIO

/* GPIO 4: FPGA_TDO	input */
#define PP_HWID_18_GPIO_04_IS_OUTPUT		0
#define PP_HWID_18_GPIO_04_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_04_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_04_IS_GPIO		PP_HWID_18_GPIO_01_IS_GPIO

/* GPIO 5: FPGA_TDI	output 1 */
#define PP_HWID_18_GPIO_05_IS_OUTPUT		1
#define PP_HWID_18_GPIO_05_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_05_OUTPUT_VALUE		1
#define PP_HWID_18_GPIO_05_IS_GPIO		PP_HWID_18_GPIO_01_IS_GPIO

/* GPIO 6: LAN port select - output 0 */
#define PP_HWID_18_GPIO_06_IS_OUTPUT		1
#define PP_HWID_18_GPIO_06_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_06_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_06_IS_GPIO		PP_HWID_18_GPIO_01_IS_GPIO

/* GPIO 7: PPC pin strapping - unused config as input */
#define PP_HWID_18_GPIO_07_IS_OUTPUT		0
#define PP_HWID_18_GPIO_07_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_07_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_07_IS_GPIO		PP_HWID_18_GPIO_01_IS_GPIO

/* GPIO 8: PPC pin strapping - unused config as input */
#define PP_HWID_18_GPIO_08_IS_OUTPUT		0
#define PP_HWID_18_GPIO_08_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_08_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_08_IS_GPIO		PP_HWID_18_GPIO_01_IS_GPIO

/* GPIO 9: FPGA_TCK	output 0 */
#define PP_HWID_18_GPIO_09_IS_OUTPUT		1
#define PP_HWID_18_GPIO_09_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_09_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_09_IS_GPIO		PP_HWID_18_GPIO_01_IS_GPIO

/* GPIO 10: PerCS1 for 2nd FLASH not GPIO */
#define PP_HWID_18_GPIO_10_IS_OUTPUT		0
#define PP_HWID_18_GPIO_10_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_10_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_10_IS_GPIO		0

/* GPIO 11: PerCS2 for VSC1_CS0 not GPIO */
#define PP_HWID_18_GPIO_11_IS_OUTPUT		0
#define PP_HWID_18_GPIO_11_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_11_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_11_IS_GPIO		0

/* GPIO 12: PerCS3 for VSC1_CS1 not GPIO */
#define PP_HWID_18_GPIO_12_IS_OUTPUT		0
#define PP_HWID_18_GPIO_12_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_12_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_12_IS_GPIO		0

/* GPIO 13: PerCS4 for VSC1_CS2 not GPIO */
#define PP_HWID_18_GPIO_13_IS_OUTPUT		0
#define PP_HWID_18_GPIO_13_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_13_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_13_IS_GPIO		0

/* GPIO 14: PerCS5 for VSC1_CS3 not GPIO */
#define PP_HWID_18_GPIO_14_IS_OUTPUT		0
#define PP_HWID_18_GPIO_14_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_14_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_14_IS_GPIO		0

/* GPIO 15: Hardware Reset	configure as input */
#define PP_HWID_18_GPIO_15_IS_OUTPUT		0
#define PP_HWID_18_GPIO_15_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_15_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_15_IS_GPIO		1

/* GPIO 16: PerCS7 for Hardware ID not GPIO */
#define PP_HWID_18_GPIO_16_IS_OUTPUT		0
#define PP_HWID_18_GPIO_16_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_16_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_16_IS_GPIO		0

/* GPIO 17: IRQ0 for VM FPGA	not GPIO */
#define PP_HWID_18_GPIO_17_IS_OUTPUT		0
#define PP_HWID_18_GPIO_17_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_17_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_17_IS_GPIO		0

/* GPIO 18: IRQ1 for Z7		not GPIO */
#define PP_HWID_18_GPIO_18_IS_OUTPUT		0
#define PP_HWID_18_GPIO_18_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_18_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_18_IS_GPIO		0

/* GPIO 19: IRQ2 for USB	not GPIO */
#define PP_HWID_18_GPIO_19_IS_OUTPUT		0
#define PP_HWID_18_GPIO_19_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_19_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_19_IS_GPIO		0

/* GPIO 20: IRQ3 for MiniPCI&UART not GPIO */
#define PP_HWID_18_GPIO_20_IS_OUTPUT		0
#define PP_HWID_18_GPIO_20_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_20_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_20_IS_GPIO		0

/* GPIO 21: IRQ4 for Gigabit ETH not GPIO */
#define PP_HWID_18_GPIO_21_IS_OUTPUT		0
#define PP_HWID_18_GPIO_21_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_21_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_21_IS_GPIO		0

/* GPIO 22: IRQ5 for Encryp	not GPIO */
#define PP_HWID_18_GPIO_22_IS_OUTPUT		0
#define PP_HWID_18_GPIO_22_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_22_OUTPUT_VALUE		0
#define PP_HWID_18_GPIO_22_IS_GPIO		0

/* GPIO 23: FPGA_TMS		output 1 */
#define PP_HWID_18_GPIO_23_IS_OUTPUT		1
#define PP_HWID_18_GPIO_23_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_23_OUTPUT_VALUE		1
#define PP_HWID_18_GPIO_23_IS_GPIO		1

/* GPIO 24: VM FPGA Reset	output 1 */
#define PP_HWID_18_GPIO_24_IS_OUTPUT		1
#define PP_HWID_18_GPIO_24_IS_OPEN_DRAIN	0
#define PP_HWID_18_GPIO_24_OUTPUT_VALUE		1
#define PP_HWID_18_GPIO_24_IS_GPIO		1

/* ----------------------------------------------------------------------------
 * External IRQ configuration
 */

/* USB_IRQ */
#define PP_HWID_18_EXT_IRQ_00_HAS_POS_POLARITY	0
#define PP_HWID_18_EXT_IRQ_00_IS_EDGE_TRIGGERED	0

/* PHY_IRQ */
#define PP_HWID_18_EXT_IRQ_01_HAS_POS_POLARITY	0
#define PP_HWID_18_EXT_IRQ_01_IS_EDGE_TRIGGERED	0

/* PCI INT A# */
#define PP_HWID_18_EXT_IRQ_02_HAS_POS_POLARITY	0
#define PP_HWID_18_EXT_IRQ_02_IS_EDGE_TRIGGERED	0

/* Used as GPIO(20) */
#define PP_HWID_18_EXT_IRQ_03_HAS_POS_POLARITY	0
#define PP_HWID_18_EXT_IRQ_03_IS_EDGE_TRIGGERED	0

/* PCI INT C# */
#define PP_HWID_18_EXT_IRQ_04_HAS_POS_POLARITY	0
#define PP_HWID_18_EXT_IRQ_04_IS_EDGE_TRIGGERED	0

/* VSC_IRQ */
#define PP_HWID_18_EXT_IRQ_05_HAS_POS_POLARITY	0
#define PP_HWID_18_EXT_IRQ_05_IS_EDGE_TRIGGERED	0

/* Used as GPIO(23) */
#define PP_HWID_18_EXT_IRQ_06_HAS_POS_POLARITY	0
#define PP_HWID_18_EXT_IRQ_06_IS_EDGE_TRIGGERED	0

/* Used as VSC */
#define PP_HWID_18_EXT_IRQ_07_HAS_POS_POLARITY	0
#define PP_HWID_18_EXT_IRQ_07_IS_EDGE_TRIGGERED	0

/* unused */
#define PP_HWID_18_EXT_IRQ_08_HAS_POS_POLARITY	0
#define PP_HWID_18_EXT_IRQ_08_IS_EDGE_TRIGGERED	0

/* unused */
#define PP_HWID_18_EXT_IRQ_09_HAS_POS_POLARITY	0
#define PP_HWID_18_EXT_IRQ_09_IS_EDGE_TRIGGERED	0

/* unused */
#define PP_HWID_18_EXT_IRQ_10_HAS_POS_POLARITY	0
#define PP_HWID_18_EXT_IRQ_10_IS_EDGE_TRIGGERED	0

/* unused */
#define PP_HWID_18_EXT_IRQ_11_HAS_POS_POLARITY	0
#define PP_HWID_18_EXT_IRQ_11_IS_EDGE_TRIGGERED	0

/* unused */
#define PP_HWID_18_EXT_IRQ_12_HAS_POS_POLARITY	0
#define PP_HWID_18_EXT_IRQ_12_IS_EDGE_TRIGGERED	0


/* ----------------------------------------------------------------------------
 * Chip Select configuration
 */

/* ---- Bank 0: Flash ---- */

#define PP_HWID_18_CS_00_AP_BME		0x1	/* Burst mode enabled (1 bit) */
#define PP_HWID_18_CS_00_AP_FWT		0x6	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_18_CS_00_AP_BWT		0x6	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_18_CS_00_AP_TWT		0x0	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_18_CS_00_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_18_CS_00_AP_OEN		0x1	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_18_CS_00_AP_WBN		0x1	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_00_AP_WBF		0x1	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_00_AP_TH		0x2	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_18_CS_00_AP_RE		0x0	/* Ready Enable (1 bit) */
#define PP_HWID_18_CS_00_AP_SOR		0x1	/* Sample on Ready (1 bit) */
#define PP_HWID_18_CS_00_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_18_CS_00_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_18_CS_00_CR_BAS		0xFE000000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_18_CS_00_CR_BS		0x5
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_18_CS_00_CR_BU		0x3
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_18_CS_00_CR_BW		0x1

/* ---- Bank 1: Flash ---- */

#define PP_HWID_18_CS_01_AP_BME		0x1	/* Burst mode enabled (1 bit) */
#define PP_HWID_18_CS_01_AP_FWT		0x6	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_18_CS_01_AP_BWT		0x6	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_18_CS_01_AP_TWT		0x0	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_18_CS_01_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_18_CS_01_AP_OEN		0x1	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_18_CS_01_AP_WBN		0x1	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_01_AP_WBF		0x1	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_01_AP_TH		0x2	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_18_CS_01_AP_RE		0x0	/* Ready Enable (1 bit) */
#define PP_HWID_18_CS_01_AP_SOR		0x1	/* Sample on Ready (1 bit) */
#define PP_HWID_18_CS_01_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_18_CS_01_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_18_CS_01_CR_BAS		0xFC000000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_18_CS_01_CR_BS		0x5
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_18_CS_01_CR_BU		0x3
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_18_CS_01_CR_BW		0x1

/* ---- Bank 2: VSC 1 ---- */

#define PP_HWID_18_CS_02_AP_BME		0x1	/* Burst mode enabled (1 bit) */
#define PP_HWID_18_CS_02_AP_FWT		0x0	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_18_CS_02_AP_BWT		0x0	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_18_CS_02_AP_TWT		0x0	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_18_CS_02_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_18_CS_02_AP_OEN		0x0	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_18_CS_02_AP_WBN		0x0	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_02_AP_WBF		0x0	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_02_AP_TH		0x0	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_18_CS_02_AP_RE		0x1	/* Ready Enable (1 bit) */
#define PP_HWID_18_CS_02_AP_SOR		0x1	/* Sample on Ready (1 bit) */
#define PP_HWID_18_CS_02_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_18_CS_02_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_18_CS_02_CR_BAS		0xF0000000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_18_CS_02_CR_BS		0x3
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_18_CS_02_CR_BU		0x3
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_18_CS_02_CR_BW		0x2

/* ---- Bank 3: VSC 2 ---- */

#define PP_HWID_18_CS_03_AP_BME		0x1	/* Burst mode enabled (1 bit) */
#define PP_HWID_18_CS_03_AP_FWT		0x0	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_18_CS_03_AP_BWT		0x0	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_18_CS_03_AP_TWT		0x0	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_18_CS_03_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_18_CS_03_AP_OEN		0x0	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_18_CS_03_AP_WBN		0x0	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_03_AP_WBF		0x0	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_03_AP_TH		0x0	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_18_CS_03_AP_RE		0x1	/* Ready Enable (1 bit) */
#define PP_HWID_18_CS_03_AP_SOR		0x1	/* Sample on Ready (1 bit) */
#define PP_HWID_18_CS_03_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_18_CS_03_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_18_CS_03_CR_BAS		0xF0800000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_18_CS_03_CR_BS		0x3
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_18_CS_03_CR_BU		0x3
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_18_CS_03_CR_BW		0x2

/* ---- Bank 4: VSC 3 ---- */

#define PP_HWID_18_CS_04_AP_BME		0x1	/* Burst mode enabled (1 bit) */
#define PP_HWID_18_CS_04_AP_FWT		0x0	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_18_CS_04_AP_BWT		0x0	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_18_CS_04_AP_TWT		0x0	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_18_CS_04_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_18_CS_04_AP_OEN		0x0	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_18_CS_04_AP_WBN		0x0	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_04_AP_WBF		0x0	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_04_AP_TH		0x0	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_18_CS_04_AP_RE		0x1	/* Ready Enable (1 bit) */
#define PP_HWID_18_CS_04_AP_SOR		0x1	/* Sample on Ready (1 bit) */
#define PP_HWID_18_CS_04_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_18_CS_04_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_18_CS_04_CR_BAS		0xF1000000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_18_CS_04_CR_BS		0x3
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_18_CS_04_CR_BU		0x3
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_18_CS_04_CR_BW		0x2

/* ---- Bank 5: VSC 4 ---- */

#define PP_HWID_18_CS_05_AP_BME		0x1	/* Burst mode enabled (1 bit) */
#define PP_HWID_18_CS_05_AP_FWT		0x0	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_18_CS_05_AP_BWT		0x0	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_18_CS_05_AP_TWT		0x0	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_18_CS_05_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_18_CS_05_AP_OEN		0x0	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_18_CS_05_AP_WBN		0x0	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_05_AP_WBF		0x0	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_05_AP_TH		0x0	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_18_CS_05_AP_RE		0x1	/* Ready Enable (1 bit) */
#define PP_HWID_18_CS_05_AP_SOR		0x1	/* Sample on Ready (1 bit) */
#define PP_HWID_18_CS_05_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_18_CS_05_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_18_CS_05_CR_BAS		0xF1800000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_18_CS_05_CR_BS		0x3
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_18_CS_05_CR_BU		0x3
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_18_CS_05_CR_BW		0x2

/* ---- Bank 6: unused ---- */

#define PP_HWID_18_CS_06_AP_BME		0x0	/* Burst mode enabled (1 bit) */
#define PP_HWID_18_CS_06_AP_FWT		0x0	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_18_CS_06_AP_BWT		0x0	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_18_CS_06_AP_TWT		0x0	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_18_CS_06_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_18_CS_06_AP_OEN		0x0	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_18_CS_06_AP_WBN		0x0	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_06_AP_WBF		0x0	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_06_AP_TH		0x0	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_18_CS_06_AP_RE		0x0	/* Ready Enable (1 bit) */
#define PP_HWID_18_CS_06_AP_SOR		0x0	/* Sample on Ready (1 bit) */
#define PP_HWID_18_CS_06_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_18_CS_06_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_18_CS_06_CR_BAS		0x00000000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_18_CS_06_CR_BS		0x0
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_18_CS_06_CR_BU		0x0
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_18_CS_06_CR_BW		0x0

/* ---- Bank 7: Hardware-ID ---- */

#define PP_HWID_18_CS_07_AP_BME		0x0	/* Burst mode enabled (1 bit) */
#define PP_HWID_18_CS_07_AP_FWT		0x0	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_18_CS_07_AP_BWT		0x0	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_18_CS_07_AP_TWT		0x8	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_18_CS_07_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_18_CS_07_AP_OEN		0x1	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_18_CS_07_AP_WBN		0x1	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_07_AP_WBF		0x1	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_18_CS_07_AP_TH		0x2	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_18_CS_07_AP_RE		0x0	/* Ready Enable (1 bit) */
#define PP_HWID_18_CS_07_AP_SOR		0x1	/* Sample on Ready (1 bit) */
#define PP_HWID_18_CS_07_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_18_CS_07_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_18_CS_07_CR_BAS		0xF2000000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_18_CS_07_CR_BS		0x0
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_18_CS_07_CR_BU		0x3
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_18_CS_07_CR_BW		0x1

/* ----------------------------------------------------------------------------
 * EBC configuration register
 */
#define PP_HWID_18_EBC_CFG_EBTC		0x1	/* ECB Three-State Control (1 bit) */
#define PP_HWID_18_EBC_CFG_PTD		0x0	/* Device-Paced Time-out Disable (1 bit) */
#define PP_HWID_18_EBC_CFG_RTC		0x3	/* Ready Timeout Count when PTD=0 (3 bit) */
#define PP_HWID_18_EBC_CFG_EMPL		0x0	/* External Master Priority Low (2 bit) */
#define PP_HWID_18_EBC_CFG_EMPH		0x0	/* External Master Priority High (2 bit) */
#define PP_HWID_18_EBC_CFG_CSTC		0x1	/* Chip Select Three-State Control (1 bit) */
#define PP_HWID_18_EBC_CFG_BPF		0x2	/* Burst Prefetch (2 bit) */
#define PP_HWID_18_EBC_CFG_EMS		0x0	/* External Master Size (2 bit) */
#define PP_HWID_18_EBC_CFG_PME		0x0	/* Power Management Enable (1 bit) */
#define PP_HWID_18_EBC_CFG_PMT		0x0	/* Power Management Timer (5 bit) */

#endif /* _HW_18_H */
