/*****************************************************************************
 *  LED routines
 *
 *  FILE: led.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>
#include <led.h>
#include <pcf8574.h>
#include <util.h>

/* Front Panel LEDs
 *   Bit 7 - User 1
 *   Bit 6 - User 2
 *   Bit 5 - User 3
 *   Bit 4 - User 4
 *   Bit 1 - Power LED (Blue)
 *   Bit 0 - Power LED (Red)
 */
#define USER1_LED               0x80
#define USER2_LED               0x40
#define USER3_LED               0x20
#define USER4_LED               0x10
#define POWER_RED_LED           0x02
#define POWER_BLUE_LED          0x01


static int check_led( int led )
{
    if (led < POWER_RED || led > IP_USER4) {
        printf("ERROR: Invalid LED id!\n");
        return -1;
    }
    return 0;
}

int led_init( void )
{
    return 0;
}

int led_cleanup( void )
{
    return 0;
}

int led_select( int *pled )
{
    unsigned long id;
    int nchars;

    printf("\nKX2.0 LED: 1. Power RED\n");
    printf("           2. Power BLUE\n");
    printf("           3. USER1\n");
    printf("           4. USER2\n");
    printf("           5. USER3\n");
    printf("           6. USER4\n");
    printf("Current test LED: %d\n", *pled);
    nchars = print_prompt("Enter LED to test: ", &id, 10);
    if( nchars > 0 && check_led(id) == 0 ) {
        *pled = id;
        return 0;
    }

    return -1;
}

int led_on( int led_id )
{
    uchar val;

    /* read current value */
    val = pcf8574_read();

    switch( led_id ) {
        case POWER_RED:
            val |= POWER_RED_LED;
            break;
        case POWER_BLUE:
            val |= POWER_BLUE_LED;
            break;
        case IP_USER1:
            val &= ~USER1_LED;
            break;
        case IP_USER2:
            val &= ~USER2_LED;
            break;
        case IP_USER3:
            val &= ~USER3_LED;
            break;
        case IP_USER4:
            val &= ~USER4_LED;
            break;
        default:
            break;
    }

    /* update */
    pcf8574_write(val);

    return 0;
}

int led_off( int led_id )
{
    uchar val;

    /* read current value */
    val = pcf8574_read();

    switch( led_id ) {
        case POWER_RED:
            val &= ~POWER_RED_LED;
            break;
        case POWER_BLUE:
            val &= ~POWER_BLUE_LED;
            break;
        case IP_USER1:
            val |= USER1_LED;
            break;
        case IP_USER2:
            val |= USER2_LED;
            break;
        case IP_USER3:
            val |= USER3_LED;
            break;
        case IP_USER4:
            val |= USER4_LED;
            break;
        default:
            break;
    }

    /* update */
    pcf8574_write(val);

    return 0;
}

int led_toggle( int led_id )
{
    uchar val;

    /* read current value */
    val = pcf8574_read();

    switch( led_id ) {
        case POWER_RED:
            if( val & POWER_RED_LED ) {
                val &= ~POWER_RED_LED;
            }
            else {
                val |= POWER_RED_LED;
            }
            break;
        case POWER_BLUE:
            if( val & POWER_BLUE_LED ) {
                val &= ~POWER_BLUE_LED;
            }
            else {
                val |= POWER_BLUE_LED;
            }
            break;
        case IP_USER1:
            if( val & USER1_LED ) {
                val &= ~USER1_LED;
            }
            else {
                val |= USER1_LED;
            }
            break;
        case IP_USER2:
            if( val & USER2_LED ) {
                val &= ~USER2_LED;
            }
            else {
                val |= USER2_LED;
            }
            break;
        case IP_USER3:
            if( val & USER3_LED ) {
                val &= ~USER3_LED;
            }
            else {
                val |= USER3_LED;
            }
            break;
        case IP_USER4:
            if( val & USER4_LED ) {
                val &= ~USER4_LED;
            }
            else {
                val |= USER4_LED;
            }
            break;
        default:
            break;
    }

    /* update */
    pcf8574_write(val);

    return 0;
}
