/*****************************************************************************
 *  Dual Power Supply routines
 *
 *  FILE: power.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>
#include <power.h>
#include <pcf8574.h>
#include <util.h>


/* dual power supply status
 *   Bit 2 - power supply 1 status
 *   Bit 3 - power supply 2 status
 */
#define POWER_SUPPLY_1          0x04
#define POWER_SUPPLY_2          0x08


static void display_status( char id, char status )
{
    printf("Power Supply %d: ", id);
    switch( status ) {
        case POWER_OFF:
            printf("OFF");
            break;
        case POWER_ON:
            printf("ON");
            break;
        default:
            printf("UNKNOWN");
    }
    printf("\n");

    return;
}

int power_get_status( void )
{
    uchar val;
    char status;
    int i;

    /*
     * According to the datasheet, I/Os should be HIGH before being used as
     * an input.
     */
    val = pcf8574_read();
    val |= (POWER_SUPPLY_1 | POWER_SUPPLY_2);
    pcf8574_write(val);

    /* read current value */
    val = pcf8574_read();

    printf("\n");
    for( i = 0; i < 2; i++ ) {
        if( val & (POWER_SUPPLY_1 << i) ) {
            status = POWER_ON;
        }
        else {
            status = POWER_OFF;
        }
        display_status(i, status);
    }

    return 0;
}
