/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

OUTPUT_ARCH(powerpc)
SEARCH_DIR("/usr/powerpc-pp-linux-uclibc/lib");
/* Do we need any of these for elf?
   __DYNAMIC = 0;    */
SECTIONS
{
  .resetvec 0xFFFFFFFC :
  {
    /* protect this section from beeing removed by the linker (--gc-sections) */
    KEEP(*(.resetvec))
  } = 0xffff

  /* Read-only sections, merged into text segment: */
  . = + SIZEOF_HEADERS;
  .interp : { *(.interp) }
  .hash          : { *(.hash)		}
  .dynsym        : { *(.dynsym)		}
  .dynstr        : { *(.dynstr)		}
  .rel.text      : { *(.rel.text .rel.text.*)		}
  .rela.text     : { *(.rela.text .rela.text.*) 	}
  .rel.data      : { *(.rel.data .rel.data.*)		}
  .rela.data     : { *(.rela.data .rela.data.*) 	}
  .rel.rodata    : { *(.rel.rodata .rel.rodata.*) 	}
  .rela.rodata   : { *(.rela.rodata .rela.rodata.*) 	}
  .rel.got       : { *(.rel.got)		}
  .rela.got      : { *(.rela.got)		}
  .rel.ctors     : { *(.rel.ctors)	}
  .rela.ctors    : { *(.rela.ctors)	}
  .rel.dtors     : { *(.rel.dtors)	}
  .rela.dtors    : { *(.rela.dtors)	}
  .rel.bss       : { *(.rel.bss)		}
  .rela.bss      : { *(.rela.bss)		}
  .rel.plt       : { *(.rel.plt)		}
  .rela.plt      : { *(.rela.plt)		}
  .init          : { *(.init)	}
  .plt 		 : { *(.plt) }
  .text      :
  {
    cpu/ppc4xx/start.o	(.text .text.*)
    KEEP(common/environment.o(.text .text.*))

    *(.text .text.*)
    KEEP(*(.fixup))
    KEEP(*(.got1))
  }
  _etext = .;
  PROVIDE (etext = .);
  .rodata    :
  {
    *(.rodata .rodata.*)
    *(.rodata1)
    *(.rodata.str1.4)
  }
  .fini      : { KEEP(*(.fini))    } =0
  .ctors     : { KEEP(*(.ctors))   }
  .dtors     : { KEEP(*(.dtors))   }

  /* Read-write section, merged into data segment: */
  . = (. + 0x00FF) & 0xFFFFFF00;
  _erotext = .;
  PROVIDE (erotext = .);
  .reloc   :
  {
    KEEP(*(.got)) 
    _GOT2_TABLE_ = .;
    KEEP(*(.got2))
    _FIXUP_TABLE_ = .;
    KEEP(*(.fixup))
  }
  __got2_entries = (_FIXUP_TABLE_ - _GOT2_TABLE_) >>2;
  __fixup_entries = (. - _FIXUP_TABLE_)>>2;

  .data    :
  {
    *(.data .data.*)
    *(.data1)
    *(.sdata .sdata.*)
    *(.sdata2 .sdata2.*)
    *(.dynamic)
    CONSTRUCTORS
  }
  _edata  =  .;
  PROVIDE (edata = .);

  __u_boot_cmd_start = .;
  .u_boot_cmd : { KEEP(*(.u_boot_cmd)) }
  __u_boot_cmd_end = .;

  __start___ex_table = .;
  __ex_table : { KEEP(*(__ex_table)) }
  __stop___ex_table = .;

  . = ALIGN(256);
  __init_begin = .;
  .text.init : { *(.text.init) }
  .data.init : { *(.data.init) }
  . = ALIGN(256);
  __init_end = .;

  __bss_start = .;
  .bss       :
  {
   *(.sbss .sbss.*) *(.scommon)
   *(.dynbss)
   *(.bss .bss.*)
   *(COMMON)
  }

  . = ((. > __bss_start) && (. < crc_offset)) ? crc_offset : 0; 
  .crcsum : 
  {
    KEEP(common/pp.o(.crcsum))
  }

  . = env_offset;
  .ppcenv :
  {
    KEEP(common/environment.o(.ppcenv))
  }
  _end = . ;
  PROVIDE (end = .);
}
