/*
 * Copyright (c) 2001 William L. Pitts
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are freely
 * permitted provided that the above copyright notice and this
 * paragraph and the following disclaimer are duplicated in all
 * such forms.
 *
 * This software is provided "AS IS" and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantability and fitness for a particular
 * purpose.
 */

#include <common.h>
#include <command.h>


#ifdef CONFIG_PEPPERCON

static int do_config(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	DECLARE_GLOBAL_DATA_PTR;
	printf("Please wait...\n");
	gd->pp.config_mode = 1;
	gd->pp.serial_debug = 0;
	return (run_command(getenv("bootcmd"), flag, 0) < 0 ? 1 : 0);
}

U_BOOT_CMD(
        config, 1,              1,      do_config,
        "config  - start configuration tool after bootup\n",
	""
);

#endif	/* CONFIG_PEPPERCON */
