
#ifndef FMAC_H
#define FMAC_H

/* I want some simple types */

typedef unsigned char			byte;
typedef unsigned short			word;
typedef unsigned long int 		dword;


#define CPE_FMAC_BASE  			0x96700000



#define RX_BUF_SIZE			(8*1024)
#define TX_BUF_SIZE			2048				/// warning: ݩM Transmit control and status register ت XPKT_SIZE @P

#define TX_REG_NUM			4					///  4  transmit descriptor
#define RX_REG_NUM			2					///  2  receiver buffer
#define MULTI_REG_NUM		8


#define ISR_REG				0x00				// interrups status register
#define IMR_REG				0x04				// interrupt maks register
#define MACMS_REG			0x08				// MAC address (Most significant)
#define MACLS_REG			0x0c				// MAC address (Least significant)

#define MULTI0MS_REG		0x10
#define MULTI0LS_REG		0x14
#define MULTI1MS_REG		0x18
#define MULTI1LS_REG		0x1c
#define MULTI2MS_REG		0x20
#define MULTI2LS_REG		0x24
#define MULTI3MS_REG		0x28
#define MULTI3LS_REG		0x2c
#define MULTI4MS_REG		0x30
#define MULTI4LS_REG		0x34
#define MULTI5MS_REG		0x38
#define MULTI5LS_REG		0x3c
#define MULTI6MS_REG		0x40
#define MULTI6LS_REG		0x44
#define MULTI7MS_REG		0x48
#define MULTI7LS_REG		0x4c


#define TCSR0_REG			0x50				// Transmit control and status register for descriptor 0
#define TCSR1_REG			0x54				// Transmit control and status register for descriptor 1
#define TCSR2_REG			0x58				// Transmit control and status register for descriptor 2
#define TCSR3_REG			0x5c				// Transmit control and status register for descriptor 3

#define TXADR0_REG			0x60				// Transmit packet address register for descriptor 0
#define TXADR1_REG			0x64				// Transmit packet address register for descriptor 1
#define TXADR2_REG			0x68				// Transmit packet address register for descriptor 2
#define TXADR3_REG			0x6c				// Transmit packet address register for descriptor 3

#define RCSR0_REG			0x70				// Receive control and status register for descriptor 0
#define RCSR1_REG			0x74				// Receive control and status register for descriptor 1

#define RXADR0_REG			0x78				// Receive Buffer address Register for Descriptor 0
#define RXADR1_REG			0x7c				// Receive Buffer address Register for Descriptor 1
#define RBUF0_PTR			0x80				// Recieve buffer pointer for descriptor 0
#define RBUF1_PTR			0x84				// Recieve buffer pointer for descriptor 1

#define MACCR_REG			0x88				// MAC control register
#define MACSR_REG			0x8c				// MAC status register
#define PHYCR_REG			0x90				// PHY control register
#define PHYWDATA_REG		0x94				// PHY Write Data register
#define FCR_REG				0x98				// Flow Control register
#define BPR_REG				0x9c				// back pressure register
#define WOLCR_REG			0xa0				// Wake-On-Lan control register
#define WOLSR_REG			0xa4				// Wake-On-Lan status register
#define WFCRC_REG			0xa8				// Wake-up Frame CRC register
#define WFBM1_REG			0xb0				// wake-up frame byte mask 1st double word register
#define WFBM2_REG			0xb4				// wake-up frame byte mask 2nd double word register
#define WFBM3_REG			0xb8				// wake-up frame byte mask 3rd double word register
#define WFBM4_REG			0xbc				// wake-up frame byte mask 4th double word register
#define TMR_REG				0xcc				// test mode register
#define Test0_REG			0xd0				// test0 register
#define Test1_REG			0xd4				// test1 register




// --------------------------------------------------------------------
//		MACCR_REG e
// --------------------------------------------------------------------
#define MULTIPKT_DIS_bit	(1UL<<16)				// disable receiving multicast packet
#define FULLDUP_bit			(1UL<<15)				// full duplex
#define CRC_APD_bit			(1UL<<14)				// append crc to transmit packet
#define MDC_SEL_bit			(1UL<<13)				// set MDC as TX_CK/10
#define RCV_ALL_bit			(1UL<<12)				// not check incoming packet's destination address
#define MULTI_EN_bit		(1UL<<9)
#define RCV_EN_bit			(1UL<<8)				// receiver enable
#define XMT_EN_bit			(1UL<<5)				// transmitter enable

#define LOOP_EN_bit			(1UL<<3)				// Internal loop-back
#define SW_RST_bit			(1UL<<2)				// software reset/
#define RDMA_EN_bit			(1UL<<1)				// enable DMA receiving channel
#define XDMA_EN_bit			(1UL<<0)				// enable DMA transmitting channel


// --------------------------------------------------------------------
//		RCSR0_REG, RCSR1_REG e
// --------------------------------------------------------------------
#define RBUF_EN				(1UL<<24)


// --------------------------------------------------------------------
//		ISR_REG  IMR_REG e
// --------------------------------------------------------------------
#define PHYSTS_CHG_bit		(1UL<<13)
#define AHB_ERR_bit			(1UL<<12)
#define RBUFF_ERR_bit		(1UL<<11)
#define RBUFF_OUT1_bit		(1UL<<10)
#define RBUFF_OUT0_bit		(1UL<<9)
#define XHANG_bit			(1UL<<8)
#define RPKT_LOST_bit		(1UL<<7)
#define RPKT_SAV_bit		(1UL<<6)
#define XPKT_LOST_bit		(1UL<<5)
#define XPKT_OK_bit			(1UL<<4)
#define XPKT_ERR_bit		(1UL<<3)
#define XPKT_FINISH_bit		(1UL<<2)
#define RPKT_ERR_bit		(1UL<<1)
#define RPKT_FINISH_bit		(1UL<<0)



// --------------------------------------------------------------------
//		TCSR0_REG, TCSR1_REG, TCSR2_REG, TCSR3_REG e
// --------------------------------------------------------------------
#define XPSENT_bit			(1UL<<26)				// Packet has been sent by tranmitter
#define XCH_ERR_bit			(1UL<<18)				// Transmit channel Error
#define COL_EX_bit			(1UL<<17)				// Packet has been dropped due to collision
#define LATE_COL_bit		(1UL<<16)				// Packet has been dropped due to late collision
#define XPKT_AVA_bit		(1UL<<11)				// Packet is ready for transmit
#define XPKT_SIZE_bit		(1UL<<0)				// Packet size for transmit, the unit is byte


// --------------------------------------------------------------------
//			structure for armboot
// --------------------------------------------------------------------

#define ARMBOOT
#ifdef ARMBOOT

	#define MAX_ADDR_LEN			6
	#define IFNAMSIZ				16

	struct net_device
	{
		void *priv;
		unsigned long base_addr;
		int irq;
		unsigned char dev_addr[MAX_ADDR_LEN]; /* hw address   */
		char name[IFNAMSIZ];
	
	};

	struct net_device_stats
	{
		unsigned long multicast;
	};
	
#endif



/* store this information for the driver.. */
struct fmac_local {


 	// these are things that the kernel wants me to keep, so users
	// can find out semi-useless statistics of how well the card is
	// performing
	struct net_device_stats stats;

#ifdef not_complete_yet
	// If I have to wait until memory is available to send
	// a packet, I will store the skbuff here, until I get the
	// desired memory.  Then, I'll send it out and free it.
	struct sk_buff * saved_skb;
#endif /* end_of_not */

 	// This keeps track of how many packets that I have
 	// sent out.  When an TX_EMPTY interrupt comes, I know
	// that all of these have been sent.
	int	packets_waiting;

	// Set to true during the auto-negotiation sequence
	int	autoneg_active;

	// Address of our PHY port
	word	phyaddr;

	// Type of PHY
	word	phytype;

	// Last contents of PHY Register 18
	word	lastPhy18;
	
	char	*rxadr_cpu[RX_REG_NUM];		/// buffer  system memory address
	u32		rxadr_dma[RX_REG_NUM];		/// buffer  physical memory address (b uClinux , O@)
	u32		rxadr_ptr[RX_REG_NUM];		/// driver U@Ūm
	
	char 	*txadr_cpu[TX_REG_NUM];
	u32		txadr_dma[TX_REG_NUM];
	
	int     tx_idx;
	int		rx_idx;
	int     maccr_val;
	unsigned int base_addr;
};


// --------------------------------------------------------------------
//		Receive Buffer  header
// --------------------------------------------------------------------
#define	MULTICAST_bit				(1UL<<24)
#define BROADCAST_bit				(1UL<<25)
#define COLLISION_bit				(1UL<<26)
#define RPACKET_SAV_bit				(1UL<<27)
#define RX_ERR_bit					(1UL<<28)
#define CRC_ERR_bit					(1UL<<29)
#define FTL_bit						(1UL<<30)
#define RUNT_bit					(1UL<<31)

#define RS_ERRORS					( COLLISION_bit | RX_ERR_bit | CRC_ERR_bit | FTL_bit | RUNT_bit )



#define FMAC_STROBE_TIME			(2*HZ)



 
#endif  /* FMAC_H */


