#ifndef _PP_COMMON_H
#define _PP_COMMON_H


/* check the defines which must be defined _before_ this file is included */
#if !defined(_BIGPHYSAREA) || \
    !defined(_TFTPBOOT_CONFIG_BOOTCOMMAND) || \
    !defined(_MEM_CONFIG_BOOTCOMMAND)
#error some variables have not been set in the board specific include file - please refer to PP_COMMON.h
#endif

#define CONFIG_PEPPERCON	1	/* ...on a PEPPERCON board */

#if defined(PP_FEAT_JFFS2_ROOTFS) || !defined(PP_FEAT_KERNEL_COMPRESSION_BZIP2)
#  define CONFIG_GZIP		1	/* We use gzip compressed images */
#else
#  define CONFIG_BZIP2          1       /* We use bzip2 compressed images */
#endif

#define DYNAMIC_CRC_TABLE	1	/* save some bytes */
#define CFG_ENV_IS_IN_FLASH     1	/* use FLASH for environment vars */

#define CONFIG_BOOTDELAY	_HWID_CONFIG_BOOTDELAY /* autoboot delay */

#define CONFIG_BAUDRATE		115200

/* #define CONFIG_BAUDRATE		38400 */

#ifdef PP_FEAT_JFFS2_ROOTFS
#  define CFG_JFFS_CUSTOM_PART	1
#  define CONFIG_COMMANDS	(CFG_CMD_BDI		\
				 | CFG_CMD_BOOTD	\
				 | CFG_CMD_IMI		\
				 | CFG_CMD_FLASH	\
				 | CFG_CMD_MEMORY	\
				 | CFG_CMD_NET		\
				 | CFG_CMD_ENV		\
				 | CFG_CMD_PCI		\
				 | CFG_CMD_RUN		\
				 | CFG_CMD_LOADB	\
				 | CFG_CMD_JFFS2	\
				 )
#else
#  define CONFIG_COMMANDS	(CFG_CMD_BDI		\
				 | CFG_CMD_BOOTD	\
				 | CFG_CMD_IMI		\
				 | CFG_CMD_FLASH	\
				 | CFG_CMD_MEMORY	\
				 | CFG_CMD_NET		\
				 | CFG_CMD_ENV		\
				 | CFG_CMD_PCI		\
				 | CFG_CMD_RUN		\
				 | CFG_CMD_LOADB	\
				 )
#endif

#define CONFIG_LOADS_ECHO	1	/* echo on for serial download */
#define CFG_LOADS_BAUD_CHANGE	1	/* allow baudrate change */
#undef CFG_LONGHELP			/* undef to save memory */
#define CFG_PROMPT	"=> "		/* Monitor Command Prompt */
#if (CONFIG_COMMANDS & CFG_CMD_KGDB)
# define CFG_CBSIZE	1024		/* Console I/O Buffer Size */
#else
# define CFG_CBSIZE	512		/* Console I/O Buffer Size */
#endif
#define CFG_PBSIZE (CFG_CBSIZE+sizeof(CFG_PROMPT)+16) /* Print Buffer Size */
#define CFG_MAXARGS	16		/* max number of command args */
#define CFG_BARGSIZE	CFG_CBSIZE	/* Boot Argument Buffer Size */

#define CFG_MALLOC_LEN		(8192 * 1024)	/* Reserve 8MB for malloc() */
						/* ... because of bzip2 */

/* allow to overwrite serial and ethaddr */
#define CONFIG_ENV_OVERWRITE	1

/*
 * For booting Linux, the board info and command line data
 * have to be in the first 8 MB of memory, since this is
 * the maximum mapped by the Linux kernel during initialization.
 */
#define CFG_BOOTMAPSZ		(8 << 20)	/* Initial Mem-map for Linux */

/*
 * if PP_FW_TYPE_PRODUCTION, we use environment options (also depending on hardware)
 * to autoboot directly from the production NFS server to start
 * flashing the firmware or to switch the OEM version
 * if !PP_FW_TYPE_PRODUCTION, the default (ramdisk...) env options are used
 */


#if defined(PP_FW_TYPE_PRODUCTION)

#  undef CFG_SERIAL_DEBUG       /* don't test for serial debug cable */
#  define CONFIG_BOOTCOMMAND    _TFTPBOOT_CONFIG_BOOTCOMMAND
#  define CONFIG_ETHADDR	FE:00:00:FF:00:00
#  define CONFIG_SERVERIP	192.168.5.1
#  define CFG_AUTOLOAD  	"yes"
#  define CONFIG_EXTRA_ENV_SETTINGS       \
    "autostart=yes\0"			  \
    "serial_debug=1\0"

#  define CONFIG_IPADDR	192.168.5.22
#  define CONFIG_BOOTFILE zImage.lara.kim.prod
#  define ROOTFS_PRODUCTION /install_root_devel

#  define CONFIG_BOOTARGS						\
    _CONFIG_BOOTARGS_PRODUCTION(CONFIG_IPADDR, ROOTFS_PRODUCTION)

#  define _CONFIG_BOOTARGS_PRODUCTION(ip, rootfs)	\
    __CONFIG_BOOTARGS_PRODUCTION(ip, rootfs)

#  define __CONFIG_BOOTARGS_PRODUCTION(ip, rootfs)	\
    "console=ttyS0,115200 root=/dev/nfs "		\
    "nfsroot=192.168.5.1:" #rootfs			\
    " ip=" #ip ":192.168.5.1 "				\
    "wdt=90 rw " _BIGPHYSAREA

#else
/* ! defined(PP_FW_TYPE_PRODUCTION) */

#  define CFG_SERIAL_DEBUG	1	/* test for serial debug cable */

/* jffs boot config, not for everybody, for the time being */
#  ifdef PP_FEAT_JFFS2_ROOTFS

#    define CONFIG_BOOTCOMMAND _JFFS_CONFIG_BOOTCOMMAND

#    ifdef CONFIG_UART1_CONSOLE

#      ifdef PP_BOARD_KIRA
#        define CONFIG_BOOTARGS    "console=ttyS1,115200 "\
         "mtdparts=phys:0x007c0000@0x00040000(root),0x00040000@0x00000000(u-boot) "\
         "root=/dev/mtdblock0 rootfstype=jffs2 init=/sbin/init ip=off wdt=90 rw "\
         _BIGPHYSAREA
#        define CONFIG_JFFS2_MTDPARTS "phys:0x007c0000@0x00040000(root),0x00040000@0x00000000(u-boot)"
#      else
#        define CONFIG_BOOTARGS    "console=ttyS1,115200 "\
         "mtdparts=phys:0x007c0000@0x00000000(root),0x00040000@0x007c0000(u-boot) "\
         "root=/dev/mtdblock0 rootfstype=jffs2 init=/sbin/init ip=off wdt=90 rw "\
         _BIGPHYSAREA
#        define CONFIG_JFFS2_MTDPARTS "phys:0x007c0000@0x00000000(root),0x00040000@0x007c0000(u-boot)"
#      endif

#    else

#      ifdef PP_BOARD_KIRA
#        define CONFIG_BOOTARGS    "console=ttyS0,115200 "			\
         "mtdparts=phys:0x007c0000@0x00040000(root),0x00040000@0x00000000(u-boot) "\
         "root=/dev/mtdblock0 rootfstype=jffs2 init=/sbin/init ip=off wdt=90 rw "\
         _BIGPHYSAREA
#      else
#        define CONFIG_BOOTARGS    "console=ttyS0,115200 "			\
         "mtdparts=phys:0x007c0000@0x00000000(root),0x00040000@0x007c0000(u-boot) "\
         "root=/dev/mtdblock0 rootfstype=jffs2 init=/sbin/init ip=off wdt=90 rw "\
         _BIGPHYSAREA
#      endif
	 
#    endif

#  else /* PP_FEAT_JFFS2_ROOTFS */

#    define CONFIG_BOOTCOMMAND	_MEM_CONFIG_BOOTCOMMAND

#    ifdef CONFIG_UART1_CONSOLE
#      define CONFIG_BOOTARGS    "console=ttyS1,115200 root=/dev/ram " \
                                 "ramdisk_size=10240 init=/sbin/init "  \
                                 "ip=off wdt=90 rw " _BIGPHYSAREA
#    else
#      define CONFIG_BOOTARGS    "console=ttyS0,115200 root=/dev/ram " \
                                 "ramdisk_size=10240 init=/sbin/init "  \
                                 "ip=off wdt=90 rw " _BIGPHYSAREA
#    endif
#  endif
#endif

#endif /* _PP_COMMON_H */
