#ifndef CPE_H
#define CPE_H

/* DO NOT EDIT!! - this file automatically generated
 *                 from .s file by awk -f s2h.awk
 */
/****************************************************************************
 * Copyright  Faraday Technology Corp 2002-2003.  All rights reserved.      *
 *--------------------------------------------------------------------------*
 * Name:cpe.s                                                               *
 * Description: CPE board specfic define                                    *
 * Author: Fred Chien                                                       *
 * **************************************************************************
 */

/* 
 *   CPE address map;
 * 
 *                +==========================================
 *     0x00000000 | ROM 
 *                |
 *     0x00080000 |==========================================
 *                | SRAM
 *                |==========================================
 *     0x10000000 | SDRAM 
 *     0x8FFFFFFF |
 *                |==========================================
 *     0x90000000 |Controller's reg				
 *                |						
 *                |0x90100000 Arbiter/Decoder             						
 *                |0x90200000 SRAM controller reg  
 *        		|0x902ffffc Debug Numberic LED					
 *                |0x90900000 SDRAM controller reg        						
 *                |0x90400000 DMA controller reg          						
 *                |0x90500000 AHB2APB bridge              						
 *                |0x90600000 Reserved                    						
 *                |0x91000000-91F00000 DMA0-DMA15 Device; 						
 *                |0x92400000 DSP                         						
 *                |0x92500000 Reserved                         						
 *                |0x96500000 LCD                         						
 *                |0x96600000 Bluetooth                        						
 *                |0x96700000 MAC        						
 *                |0x96800000 PCI                       						
 *                |0x96900000 USB2.0 host                       
 *                |0x98000000-9AFFFFFF APB Device                                        
 *     0x98000000 |==========================================
 *                | APB Device's Reg
 *                |
 *                |0x98000000 Reserved
 *                |0x98100000 Power Managemnet
 *                |0x98200000 UART1
 *                |0x98300000 UART2/IrDA
 *                |0x98400000 Timer
 *                |0x98500000 Watchdog Timer
 *                |0x98600000 RTC
 *                |0x98700000 GPIO
 *                |0x98800000 INTC
 *                |0x98900000 UART3
 *                |0x98A00000 I2C
 *                |0x98B00000 SSP1
 *                |0x98C00000 USB Device
 *                |0x98D00000 Compact Flash
 *                |0x98E00000 Secure Digital
 *                |0x98F00000 SMC
 *                |0x99000000 MS
 *                |0x99100000 SCI
 *                |0x99200000 ECP/EPP
 *                |0x99300000 KBC                 
 *                |0x99400000 I2S                 
 *                |0x99500000 AC97                 
 *                |0x99600000 SSP2                 
 *                |0x99700000 Mouse                 
 *                |0x9AFFFFFF Reserved                             
 *                |          
 *                +==========================================
 */

#include 	"chipset.h"
#include        "kira100.h"

/* ===============================================================================
 *  CPE definitions
 * ===============================================================================
 * -------------------------------------------------------------------------------
 *  Memory definitions
 * -------------------------------------------------------------------------------
 */

#define CPE_MAX_AHBC                    105000000

#define CPE_ROM_LO                      0x00000000
#define CPE_ROM_HI                      0x80000000
#define CPE_ROM_BASE                    CPE_ROM_HI	   /* remap position */
#define CPE_ROM_SIZE                    SZ_128K

#define CPE_SRAM_LO                     0x00080000
#define CPE_SRAM_HI                     0x80080000  
#define CPE_SRAM_BASE                   CPE_SRAM_HI    /* remap position */
#define CPE_SRAM_SIZE                   SZ_512K

#define CPE_SDRAM_LO                    0x00000000
#define CPE_SDRAM_HI                    0x10000000
#define CPE_SDRAM_BASE                  CPE_SDRAM_LO   /* remap postion  */
#define CPE_SDRAM_SIZE                  SZ_128M


/*  -------------------------------------------------------------------------------
 *   CPE system registers
 *  ------------------------------------------------------------------------------- 
 */

#define SRAMBANK_BASE               	CPE_SRAM_LO

/* -------------------------------------------------------------------------------
 *  APB Device definitions
 * -------------------------------------------------------------------------------
 */


#define CPE_PMU_REG_PMODE		0x0000000c
#define CPE_PMU_REG_PMCR                0x00000010
#define CPE_PMU_REG_PDLLCR0		0x00000030



#define CPE_PMU_PMODE_DIVAHBCLK_MASK	0x00000070
#define CPE_PMU_PMODE_DIVAHBCLK_RES1	0x00000070
#define CPE_PMU_PMODE_DIVAHBCLK_RES2	0x00000060
#define CPE_PMU_PMODE_DIVAHBCLK_RES3	0x00000050
#define CPE_PMU_PMODE_DIVAHBCLK_8X	0x00000040
#define CPE_PMU_PMODE_DIVAHBCLK_6X	0x00000030
#define CPE_PMU_PMODE_DIVAHBCLK_4X	0x00000020
#define CPE_PMU_PMODE_DIVAHBCLK_3X	0x00000010
#define CPE_PMU_PMODE_DIVAHBCLK_2X	0x00000000

#define CPE_PMU_PMODE_FCS		0x00000004
#define CPE_PMU_PMODE_TURBO		0x00000002
#define CPE_PMU_PMODE_SLEEP		0x00000001

#define CPE_PMU_PDLLCR0_DLLFRANG_MASK   (0x1 << 20)
#define CPE_PMU_PDLLCR0_DLLFRANG100_300 (0x1 << 20)
#define CPE_PMU_PDLLCR0_DLLFRANG20_100  (0x0)

#define CPE_PMU_PDLLCR0_PLL1FRANG_MASK	0x00018000
#define CPE_PMU_PDLLCR0_PLL1FRANG20	0x00000000
#define CPE_PMU_PDLLCR0_PLL1FRANG50	0x00008000
#define CPE_PMU_PDLLCR0_PLL1FRANG90	0x00010000
#define CPE_PMU_PDLLCR0_PLL1FRANG150	0x00018000

#define CPE_PMU_PDLLCR0_PLL1MS_MASK     0x00007e00
#define CPE_PMU_PDLLCR0_PLL1MS_POS      9
#define CPE_PMU_PDLLCR0_PLL1N_MASK      0x000001f8
#define CPE_PMU_PDLLCR0_PLL1N_POS       3



#define SYS_CLK                     	CONFIG_SYS_CLK_FREQ
#define CPU_CLK                         SYS_CLK * CONFIG_SYS_CLK_DIVIDER
#define AHB_CLK                     	SYS_CLK
#define MAX_TIMER                   	3
#define APB_CLK                     	(SYS_CLK / 2)	
#define DEFAULT_TICK                	1
#define PCLK_HZ				(SYS_CLK/4)


#define CPE_UART_CLOCK      CONFIG_UART_CLOCK
#define CPE_BAUD_115200	    (CPE_UART_CLOCK /1843200)
#define CPE_BAUD_57600	    (CPE_UART_CLOCK /921600)
#define CPE_BAUD_38400	    (CPE_UART_CLOCK /614400)
#define CPE_BAUD_19200	    (CPE_UART_CLOCK /307200)
#define CPE_BAUD_14400	    (CPE_UART_CLOCK /230400)
#define CPE_BAUD_9600	    (CPE_UART_CLOCK /153600)


#define HOST_COMPORT                    CPE_UART1_BASE  
#define HOST_IRQBIT_NUMBER              IRQ_UART1       

/* Default port for use by Operating System or program  */
#define OS_COMPORT                      CPE_UART2_BASE
#define OS_IRQBIT_NUMBER                IRQ_UART2     

#define DEBUG_COMPORT                   OS_COMPORT
#define DEBUG_IRQBIT                    OS_IRQBIT
#define MAX_UART_NUM                    2	

/* Values to set given baud rates */
#define DEFAULT_HOST_BAUD               CPE_BAUD_9600


/* NUMBERIC DISPLAY LED	*/
#define CPE_DBG_ALPHA                   0x902ffffc



#endif
