#ifndef __KIRA_SSP_H__
#define __KIRA_SSP_H__

#define CPE_APBDMA_CHANNEL0_BASE    (CPE_APBDMA_BASE+0x80)
#define CPE_APBDMA_CHANNEL2_BASE    (CPE_APBDMA_BASE+0xA0)

/* register list */
#define SSPCR0		0x0
#define SSPCR1		0x1
#define SSPCR2		0x2
#define SSPSR		0x3
#define SSPICR		0x4
#define SSPISR		0x5
#define SSPDR		0x6
#define SSPVR		0x7
#define SSPRR		0x10
#define SSPFR		0x11

#define SSP_FRFORMAT_SSP	0x0
#define SSP_FRFORMAT_SPI	0x1
#define SSP_FRFORMAT_MW		0x2
#define SSP_FRFORMAT_I2S	0x3
#define SSP_FRFORMAT_ACLINK	0x4

#define SSP_OPM_MASTERSTEREO	0x3
#define SSP_OPM_MASTERMONO	0x2
#define SSP_OPM_SLAVESTEREO	0x1
#define SSP_OPM_SLAVEMONO	0x0

#define SSPCR0_FRFORMAT_SHIFT	12
#define SSPCR0_FRFORMAT_MASK 	(0x7 << SSPCR0_FRFORMAT_SHIFT)
#define SSPCR0_FSDIST_SHIFT	8
#define SSPCR0_FSDIST_MASK	(0x3 << SSPCR0_FSDIST_SHIFT)
#define SSPCR0_LBM		(1 << 7)
#define SSPCR0_LSB		(1 << 6)
#define SSPCR0_FSPO		(1 << 5)
#define SSPCR0_FSJSTFY		(1 << 4)
#define SSPCR0_OPM_SHIFT	2
#define SSPCR0_OPM_MASK		(0x3 << SSPCR0_OPM_SHIFT)
#define SSPCR0_SCLKPO		(1 << 1)
#define SSPCR0_SCLKPH		(1 << 0)

#define SSPCR1_PDL_SHIFT	24
#define SSPCR1_PDL_MASK		(0xff << SSPCR1_PDL_SHIFT)
#define SSPCR1_SDL_SHIFT	16
#define SSPCR1_SDL_MASK		(0x1f << SSPCR1_SDL_SHIFT)
#define SSPCR1_SCLKDIV_MASK	0xffff

#define SSPCR2_SSPRST		(1 << 6)
#define SSPCR2_ACCRST		(1 << 5)
#define SSPCR2_ACWRST		(1 << 4)
#define SSPCR2_TXFCLR		(1 << 3)
#define SSPCR2_RXFCLR		(1 << 2)
#define SSPCR2_TXDOE		(1 << 1)
#define SSPCR2_SSPEN		(1 << 0)

#define SSPSR_TFVE_SHIFT	12
#define SSPSR_TFVE_MASK		(0x1f << SSPSR_TFVE_SHIFT)
#define SSPSR_RFVE_SHIFT	4
#define SSPSR_RFVE_MASK		(0x1f << SSPSR_RFVE_SHIFT)
#define SSPSR_BUSY		(1 << 2)
#define SSPSR_TFNF		(1 << 1)
#define SSPSR_RFF		(1 << 0)

#define SSPICR_TFTHOD_SHIFT	12
#define SSPICR_TFTHOD_MASK	(0xf << SSPICR_TFTHOD_SHIFT)
#define SSPICR_RFTHOD_SHIFT	8
#define SSPICR_RFTHOD_MASK	(0xf << SSPICR_RFTHOD_SHIFT)
#define SSPICR_AC97FCEN		(1 << 6)
#define SSPICR_TFDMAEN		(1 << 5)
#define SSPICR_RFDMAEN		(1 << 4)
#define SSPICR_TFTHIEN		(1 << 3)
#define SSPICR_RFTHIEN		(1 << 2)
#define SSPICR_TFURIEN		(1 << 1)
#define SSPICR_RFORIEN		(1 << 0)

#define SSPISR_AC97FCI		(1 << 4)
#define SSPISR_TFTHI		(1 << 3)
#define SSPISR_RFTHI		(1 << 2)
#define SSPISR_TFURI		(1 << 1)
#define SSPISR_RFORI		(1 << 0)

#define SSPRR_MAJOR_SHIFT	16
#define SSPRR_MAJOR_MASK	(0xff << SSPRR_MAJOR_SHIFT)
#define SSPRR_MINOR_SHIFT	8
#define SSPRR_MINOR_MASK	(0xff << SSPRR_MINOR_SHIFT)
#define SSPRR_REL_MASK		0xff

#define SSPFR_SSP_MASK		(1 << 27)
#define SSPFR_SPI_MASK		(1 << 26)
#define SSPFR_I2S_MASK		(1 << 25)
#define SSPFR_AC97_MASK		(1 << 24)
#define SSPFR_TXFIFO_SHIFT	16
#define SSPFR_TXFIFO_MASK	(0xff << SSPFR_TXFIFO_SHIFT)
#define SSPFR_RXFIFO_SHIFT	8
#define SSPFR_RXFIFO_MASK	(0xff << SSPFR_RXFIFO_SHIFT)
#define SSPFR_FIFO_WIDTH_MASK	0xff

/* APB DMA */
#define APBDMA_SOURCE           0x0
#define APBDMA_DEST             0x1
#define APBDMA_CYCLES           0x2
#define APBDMA_CONTROL          0x3

/* misc */
#define SSP_TX_DMA  0x0
#define SSP_RX_DMA  0x1

#define SSP_DMA_BUF_SIZE 512
#define SSP_DMA_TX_THRESHOLD 4
#define SSP_DMA_RX_THRESHOLD 1

typedef struct {
    void *priv;
    volatile ulong *base;
    volatile ulong *txdma_base;
    volatile ulong *rxdma_base;
} ssp_dev_t;

/* function prototypes */
int ssp_init(void);
void ssp_uninit(void);
int ssp_txrx(char *inbuf, char *outbuf, unsigned int count);
int addr_spi(ulong addr);

#endif
