#!/usr/bin/perl -w
# 
# used as filepp module in generating the menu part of the .asp pages
# 

use strict;

sub parse_menu_file($) {
    my $menu = ();
    my $akt_entry = {};

    my $menu_file = shift || die "no menu file supplied\n";

    open(MF, "<$menu_file") or die "can't open $menu_file";

    while (<MF>) {
	if (/^\s*$/) { next; }  # skip empty lines
	if (/^[^\s]+/) {
	    # process indented line - menu entry
	    $_ =~ s/^\s*(.*?)\s*$/$1/ ;
	    if ((my $menu_entry, my $icon, my $link, my $cond_show) = split /\|/) {

	      if (defined $akt_entry->{"list"}) {
		  push @{$menu}, $akt_entry;
	      }
	      $akt_entry = {};
	      $akt_entry->{"list"} = ();
	      $akt_entry->{"name"} = $menu_entry;
	      $akt_entry->{"iconname"} = defined($icon) ? $icon : "";
	      $akt_entry->{"link"} = defined($link) ? $link : "";
	      $akt_entry->{"show_cond"} = defined($cond_show) ? $cond_show : "";

	      ($akt_entry->{"shortname"} = $menu_entry) =~ s/\s//g;
	    }
	} else {
	    # process un-indented line - menu headline
	    $_ =~ s/^\s*(.*?)\s*$/$1/ ;
	    if (!defined $akt_entry->{"name"}) {
		next;
	    }
	    s/^[\s]*//g;
	    if ((my $menu_entry, my $html, my $target, my $cond_show) = split /\|/) {
		next if (!defined $menu_entry);
		my $entry = {};
		# name to display
		$entry->{"name"} = $menu_entry;
		# name of .asp page
		if (defined $html) {
		    $entry->{"url"} = $html;
		}
		# name of target frame
		if (defined $target) {
		    $entry->{"target"} = $target;
		}

  	        $entry->{"show_cond"} = defined($cond_show) ? $cond_show : "";

		push @{$akt_entry->{"list"}}, $entry;
	    }
	}
    }

    if (defined $akt_entry->{"list"}) {
	push @{$menu}, $akt_entry;
    }

    return $menu;
}

sub parse_acl_file($) {
    my $acls = ();
    my $akt_entry = {};

    my $acl_file = shift || die "no acl file supplied\n";

    open(MF, "<$acl_file") or die "can't open $acl_file";

    while (<MF>) {
	if (/^\s*$/) { next; }  # skip empty lines
	    if ((my $file, my $acl) = split /\|/) {
	      $akt_entry = {};
	      $akt_entry->{"file"} = defined($file) ? $file : "";
	      $akt_entry->{"acl"} = defined($acl) ? $acl : "";
	      $akt_entry->{"acl"} =~ s/\s//g;
	      $akt_entry->{"acl"} =~ s/\n//g;
	      push @{$acls}, $akt_entry;
	    }
    }
    return $acls;
}

sub gen_menu($$) {
	# name of menu definition file
    my $menudef_file = shift;
	# name of current .asp page
    my $curr_page_fname     = shift;
	# ID of selected menu block
    my $sel_block_shortname;

    my $t = "";
    my $menu = parse_menu_file($menudef_file);
    my $acls = parse_acl_file('acl.tmp');

    $t .= "<!-- ____menu_begin____ -->\n";
    $t .= "<td valign=\"top\" class=\"menu\">\n";
    $t .= "<table style=\"border-collapse:collapse\" cellpadding=\"0\" cellspacing=\"0\"><thead><tr><th></th></tr></thead><tfoot><tr><td></td></tr></tfoot>\n";
    $t .= "<tbody><tr style=\"height:35px;\"><td></td></tr></tbody>\n";
    for my $big_menu_item (@{$menu}) {
	my $block_name = $big_menu_item->{name};
	my $block_shortname = $big_menu_item->{shortname};
	my $block_iconname = $big_menu_item->{iconname};
	# set $is_block_sel, if the selected entry is in the current menu block
	my $is_block_sel = 0;
	for my $small_menu_item (@{$big_menu_item->{"list"}}) {
	    my $url = $small_menu_item->{'url'};
	    if ($curr_page_fname eq $small_menu_item->{'url'}) {
		$is_block_sel = 1;
		$sel_block_shortname = $block_shortname;
	    }
	}
	$t .= "<tbody><tr><td width=\"5\" align=\"right\"><img src=\"big_menu_bg_l.gif\"></td><td height=\"40\" class=\"menu_item\"><a class=\"menu_link\" href=\"javascript:toggleItem('$block_shortname')\"><img src=\"$block_iconname\" align=\"middle\" border=\"0\" alt=\"\">&nbsp;$block_name&nbsp;</a></td><td width=\"20\" align=\"left\"><img src=\"big_menu_bg_r.gif\"></td></tr></tbody>\n";
	$t .= "<tbody class=\"menublock\" id=\"$block_shortname\">\n";

	# acls for $big_menu_item AND his $small_menu_item's ... starts with the expression from menu.def

	for my $small_menu_item (@{$big_menu_item->{"list"}}) {
	    my $sname = $small_menu_item->{'name'};
	    my $url = defined($small_menu_item->{'url'}) ? $small_menu_item->{'url'} : "";
	    
	    # cut parameters
	    my $myurl=$url;
	    $myurl =~ s/\?.*//g;
	    my $smallacls = "";

            if ($myurl) {
                for my $acl_item (@{$acls}) {
            	    my $file_name =  defined($acl_item->{'file'}) ? $acl_item->{'file'} : "";
            	    if ( $file_name eq $myurl ) { $smallacls .= defined($acl_item->{'acl'}) ? "+".$acl_item->{'acl'} : ""; }
                }
            }
            if ($smallacls eq "") { 
                $smallacls = $small_menu_item->{'show_cond'};
            } else {
                $smallacls = "[".$smallacls."]".$small_menu_item->{'show_cond'};
            }

	    my $item_is_sel = ($curr_page_fname eq $url);
	    my $url_base = $url;
	    $url_base =~ s/\.asp.*$//;
	    my $targetstr = defined($small_menu_item->{'target'}) ? "target=\"$small_menu_item->{'target'}\"" : "";
	    my $class;
	    my $item_image;
	    my $class_disabled = "sub_menu_item_disabled";
	    my $item_image_disabled = "menu_item_disabled.gif";
	    if ($item_is_sel) {
		# selected item
		$class = "sub_menu_item_sel";
		$item_image = "menu_item_highlight.gif";
	    } else {
		# unselected item
		$class = "sub_menu_item";
		$item_image = "menu_item_normal.gif";
	    }

	    # add the link or static text if no url defined
	    if (!($smallacls eq "")) {
	        $t .= "<% inneracl = AclLinkCheck(\"".$smallacls.";\"); if (!(inneracl)) { skipStart(); } %>";
	    }
	    if (defined($url)) {
	        $t .= "<tr><td colspan=\"3\"class=\"$class\">\n";
		$t .= "  <a  $targetstr href=\"$url\" class=\"menu_link\"><img src=\"$item_image\" align=\"middle\" border=\"0\" alt=\"\">$sname</a>\n";
	    } else {
		$t .= "  $sname\n";
	    }
	    if (!($smallacls eq "")) {
	        $t .= "<% if (!(inneracl)) { skipEnd(); } %>\n";
	        $t .= "<% if ((inneracl)) { skipStart(); } %>\n";
	        $t .= "<tr><td colspan=\"3\"class=\"$class_disabled\">\n";
		$t .= "  <img src=\"$item_image_disabled\" align=\"middle\" border=\"0\" alt=\"\">$sname</a>\n";
	        $t .= "<% if ((inneracl)) { skipEnd(); } %>\n";
	    }

	    $t .= "</td></tr>\n";
	}
	$t .= "</tbody>\n";
    }
    $t .= "</table>\n";

    # emit JS to open selected menu block
    if (!defined($sel_block_shortname)) {
	# all menu blocks closed
	$sel_block_shortname = "";   
    }
    $t .= "<script type=\"text/javascript\">\n";
    $t .= "  <!--\n";
    $t .= "    setMenu(\"$sel_block_shortname\");\n";
    $t .= "  -->\n";
    $t .= "</script>\n";

    $t .= "</td>\n";
    $t .= "<!-- ____menu_end____ -->\n";

    return $t;
}

sub write_file($$) {
    my $file = shift;
    my $data = shift;
    $data = () unless $data;
    
    open F, "> $file" or die "Can't open $file : $!";
    print F $data;
    close F;
}

sub read_file($) {
    my $file = shift;
    my $t = "";
    
    open F, "< $file" or die "Can't open $file : $!";
    while (<F>) {
         $t .= $_;
    }
    close F;
    
    return $t;
}

sub gen_peppercon_menu($$) {
    my $menudef_file = shift;
	# name of current .asp page
    my $curr_page_fname     = shift;
	# ID of selected menu block

    my $t = gen_menu($menudef_file, $curr_page_fname);
    my $fn = $curr_page_fname . ".menu.tmp.in";

    write_file($fn, $t);
}

sub replace_menu($$$) {
    my $curr_page_fname     = shift;
    my $curr_menu_fname     = shift;
    my $search_text         = shift;
    
    my $t = "";
    my $rep = read_file($curr_menu_fname);

    open F, "< $curr_page_fname" or die "Can't open $curr_page_fname : $!";
    while (<F>) {
        if ($_ =~ m/$search_text/) {
            $t .= $rep;
        } else {
            $t .= $_;
        }
    }
    close F;
    
    write_file($curr_page_fname, $t);
}

return 1;
#
###############################################################################
# Emacs
#
# Local Variables:
# cperl-indent-level:4
# cperl-continued-statement-offset:4
# cperl-continued-brace-offset:-4
# cperl-brace-offset:0
# cperl-brace-imaginary-offset:0
# cperl-label-offset:-2
# cperl-hairy:t
# perl-tab-always-indent:nil
# End:
###############################################################################
