#!/usr/bin/perl -w
# 
# used as filepp module in generating the menu part of the .asp pages
# 

use strict;

sub parse_menu_file($) {
    my $menu = ();
    my $akt_entry = {};

    my $menu_file = shift || die "no menu file supplied\n";

    open(MF, "<$menu_file") or die "can't open $menu_file";

    while (<MF>) {
	if (/^\s*$/) { next; }  # skip empty lines
	if (/^[^\s]+/) {
	    # process indented line - menu entry
	    $_ =~ s/^\s*(.*?)\s*$/$1/ ;
	    if ((my $menu_entry, my $icon) = split /\|/) {

	      if (defined $akt_entry->{"list"}) {
		  push @{$menu}, $akt_entry;
	      }
	      $akt_entry = {};
	      $akt_entry->{"list"} = ();
	      $akt_entry->{"name"} = $menu_entry;
	      $akt_entry->{"iconname"} = defined($icon) ? $icon : "";

	      ($akt_entry->{"shortname"} = $menu_entry) =~ s/\s//g;
	    }
	} else {
	    # process un-indented line - menu headline
	    $_ =~ s/^\s*(.*?)\s*$/$1/ ;
	    if (!defined $akt_entry->{"name"}) {
		next;
	    }
	    s/^[\s]*//g;
	    if ((my $menu_entry, my $html, my $target) = split /\|/) {
		next if (!defined $menu_entry);
		my $entry = {};
		# name to display
		$entry->{"name"} = $menu_entry;
		# name of .asp page
		if (defined $html) {
		    $entry->{"url"} = $html;
		}
		# name of target frame
		if (defined $target) {
		    $entry->{"target"} = $target;
		}
		push @{$akt_entry->{"list"}}, $entry;
	    }
	}
    }

    if (defined $akt_entry->{"list"}) {
	push @{$menu}, $akt_entry;
    }

    return $menu;
}

sub gen_menu($$) {
	# name of menu definition file
    my $menudef_file = shift;
	# name of current .asp page
    my $curr_page_fname     = shift;
	# ID of selected menu block
    my $sel_block_shortname;

    my $t = "";
    my $menu = parse_menu_file($menudef_file);

    for my $big_menu_item (@{$menu}) {
	my $block_name = $big_menu_item->{name};
	my $block_shortname = $big_menu_item->{shortname};
	my $block_iconname = $big_menu_item->{iconname};

	# extract id = 'bla blub' from <% _("bla blub") %>
	my $id = $block_name;
	$id =~ s/.*\"(.*)\".*/$1/;

	# replace 'space' with '_'
	my $id_ = $id;
	$id_ =~ s/\s/_/g;
	$t .= "            <!-- $id --> \n";
	$t .= "                <td class=\"nav_tab_start\"><div id=\"start_$id_\" class=\"nav_tab_start\"></div></td>\n";
	$t .= "                <td id=\"middle_$id_\" class=\"nav_tab_middle\" onmouseover=\"showSubMenu('$id_');\" onmouseout=\"hideSubMenu('$id_');\"><div id=\"link_$id_\" class=\"nav_tab_link\"><a href=\"menu_$id_.asp\" target=\"container\">$block_name</a></div></td>\n";
	$t .= "                <td class=\"nav_tab_end\"><div id=\"end_$id_\" class=\"nav_tab_end\"></div></td>\n";
    }
    return $t;
}

sub find_parent($$) {
	# name of menu definition file
    my $menudef_file = shift;
	# name of current .asp page
    my $p_url     = shift;
	# title of current page
    my $titleormenu = shift;
	# seperator
    my $mparent = shift;
	# seperator

    my $sep = "";
    if ($titleormenu eq "menu") {
	# = " > ";
	$sep = " &#62; ";
    } elsif ($titleormenu eq "title") {
	# = " | ";
        $sep = " &#124; ";
    } elsif ($titleormenu eq "link") {
        $sep = shift;
    }
    my $t = $sep;
    my $menu = parse_menu_file($menudef_file);

    if ($mparent eq "<>") {
      for my $big_menu_item (@{$menu}) {
	my $block_name = $big_menu_item->{name};
	my $block_shortname = $big_menu_item->{shortname};

	# extract id = bla from <% _("bla") %>
	my $id = $block_name;
	$id =~ s/.*\"(.*)\".*/$1/;

	# replace 'space' with '_'
	my $id_ = $id;
	$id_ =~ s/\s/_/g;

	for my $small_menu_item (@{$big_menu_item->{"list"}}) {
	    my $sname = $small_menu_item->{'name'};
	    my $url = defined($small_menu_item->{'url'}) ? $small_menu_item->{'url'} : "";

	    if ($p_url eq $url) {
		if ($titleormenu eq "menu") {
		    $t = $sep;
		    $t .= "<a href=\"/menu_$id_.asp\">$block_name</a>";
		    $t .= $sep;
		} elsif ($titleormenu eq "title") {
		    $t = $sep;
		    $t .= "$block_name";
		    $t .= $sep;
		} elsif ($titleormenu eq "link") {
		    $t = "<a href=\"/menu_$id_.asp\">$sep</a>";
		}
	    }
	}
      }
    } else {
	if ($titleormenu eq "menu") {
	    $t = $sep;
	    $t .= $mparent;
	    $t .= $sep;
	} elsif ($titleormenu eq "title") {
	} elsif ($titleormenu eq "link") {
	}
    }

    return $t;
}

sub underline($$) {
	# name of menu definition file
    my $menudef_file = shift;
	# name of current .asp page
    my $p_url     = shift;
	# title of current page

    my $stdnavtabs = "";
    my $activenavtab = "";
    my $menu = parse_menu_file($menudef_file);

    for my $big_menu_item (@{$menu}) {
		my $block_name = $big_menu_item->{name};
		my $block_shortname = $big_menu_item->{shortname};

		# extract id = bla from <% _("bla") %>
		my $id = $block_name;
		$id =~ s/.*\"(.*)\".*/$1/;

		# replace 'space' with '_'
		my $id_ = $id;
		$id_ =~ s/\s/_/g;

		my $ul = 0;
		for my $small_menu_item (@{$big_menu_item->{"list"}}) {
			my $sname = $small_menu_item->{'name'};
			my $url = defined($small_menu_item->{'url'}) ? $small_menu_item->{'url'} : "";

		    if ($p_url eq $url) {
				$ul = 1;
				$activenavtab = "$id_";
			}
		}

		my $indexurl = "menu_";
		$indexurl .= $id_;
		$indexurl .= ".asp";

		if ( $ul == 0 ) {
			if ($p_url eq $indexurl) {
				$activenavtab = "$id_";
			} else {
				$stdnavtabs .= "\"$id_\", ";
			}
		}
    }

	if (length($stdnavtabs) != 0) {
		chop($stdnavtabs);
		chop($stdnavtabs);
	}
    return "formatNavTabs(new Array($stdnavtabs), \"$activenavtab\");";
}

sub gen_index_files($$) {
	# name of menu definition file
    my $menudef_file = shift;
    my $menu = parse_menu_file($menudef_file);

    for my $big_menu_item (@{$menu}) {
        my $t = "";
	my $block_name = $big_menu_item->{name};
	my $block_iconname = $big_menu_item->{iconname};
	my $file = "menu_";
	# extract id = bla from <% _("bla") %>
	my $id = $block_name;
	$id =~ s/.*\"(.*)\".*/$1/;

	# replace 'space' with '_'
	my $id_ = $id;
	$id_ =~ s/\s/_/g;

	$t .= "INDEX_PAGE_BEGIN($block_name) \n";
	$t .= "   INDEX_GROUP_BEGIN($block_name) <br \>\n";
	for my $small_menu_item (@{$big_menu_item->{"list"}}) {
	    my $sname = $small_menu_item->{'name'};
	    my $url = defined($small_menu_item->{'url'}) ? $small_menu_item->{'url'} : "";
            my $targetstr = defined($small_menu_item->{'target'}) ? "target=\"$small_menu_item->{'target'}\"" : "target=\"container\"";
	    my $sid = $sname;
	    $sid =~ s/.*\"(.*)\".*/$1/;
	    $t .= "<a $targetstr href=\"$url\" title=\"$sid\">$sname</a><br>\n";
	}
	$t .= "   INDEX_GROUP_END()\n";
	$t .= "INDEX_PAGE_END() \n";
	$file .= $id_;
	write_file($file, $t);
    }
    return 1;
}

sub write_file($$)
{
        my $file = shift;
	my $data = shift;
        $data = () unless $data;

	$file .= ".asp.in";
        open F, "> $file" or die "Can't open $file : $!";
        print F $data;
        close F;
}

sub gen_submenu($$) {
    # name of menu definition file
    my $menudef_file = shift;
    my $menu = parse_menu_file($menudef_file);
    my $t = "";

    for my $big_menu_item (@{$menu}) {
	my $block_name = $big_menu_item->{name};
	my $block_shortname = $big_menu_item->{shortname};
	# extract id = bla from <% _("bla") %>
	my $id = $block_name;
	$id =~ s/.*\"(.*)\".*/$1/;

	# replace 'space' with '_'
	my $id_ = $id;
	$id_ =~ s/\s/_/g;

	$t .= "<div id=\"sm_".$id_."\" class=\"submenu\" onmouseover=\"showSubMenu('".$id_."');\" onmouseout=\"hideSubMenu('".$id_."');\">\n";
	for my $small_menu_item (@{$big_menu_item->{"list"}}) {
	    my $sname = $small_menu_item->{'name'};
	    my $url = defined($small_menu_item->{'url'}) ? $small_menu_item->{'url'} : "";
            my $targetstr = defined($small_menu_item->{'target'}) ? "target=\"$small_menu_item->{'target'}\"" : "target=\"container\"";
	    $t .= "<div class=\"submenu_item\" onmouseover=\"this.className='submenu_item_sel';\" onmouseout=\"this.className='submenu_item';\">\n<a title=\"".$sname."\" href=\"".$url."\" $targetstr>\n<div class=\"submenu_content\">&nbsp;&nbsp;".$sname."&nbsp;&nbsp;</div>\n</a></div>\n";
	}
	$t .= "</div>\n";
    }
    return $t;
}

return 1;
#
###############################################################################
# Emacs
#
# Local Variables:
# cperl-indent-level:4
# cperl-continued-statement-offset:4
# cperl-continued-brace-offset:-4
# cperl-brace-offset:0
# cperl-brace-imaginary-offset:0
# cperl-label-offset:-2
# cperl-hairy:t
# perl-tab-always-indent:nil
# End:
###############################################################################
