/* ----------------------------------------------------------------------------
 * Links
 */

.notice a:link    { color: #a51924; }
.notice a:visited { color: #a51924; }
.notice a:active  { color: #ffffff; }

a.menu_link:link {
      text-decoration: none;
}

a.menu_link:visited {
      text-decoration: none;
}

a.menu_link:active {
      text-decoration: none;
}

a.menu_link:hover {
      text-decoration: underline;
}

/* ----------------------------------------------------------------------------
 * Menu
 */

.menu {
      background-color: #d5d5d5;
      min-width: 200px;
      width: 200px;
      white-space: nowrap;
}

.menu_item {
      background-image: url(big_menu_bg_c.gif); 
      background-repeat: repeat;
      background-color: #d5d5d5;
      font-weight: bold;
      white-space: nowrap;
}

.menu_item a {
      color: #ffffff;
}

.sub_menu_item {
      font-family : Arial, Helvetica, sans-serif;
      font-size : 10pt;
      font-weight : bold;
      padding-left: 10px;
      background-color: #d5d5d5;
      max-width: 200px;
      overflow:hidden;
      white-space: nowrap;
}

.sub_menu_item a {
      color: #000000;
}

.sub_menu_item_sel {
      font-family : Arial, Helvetica, sans-serif;
      font-size : 10pt;
      font-weight : bold;
      padding-left: 10px;
      background-color: #ffffff;
      max-width: 200px;
      overflow:hidden;
      white-space: nowrap;
}

.sub_menu_item_sel a {
      color: #000000;
}

.sub_menu_item_disabled {
      font-family : Arial, Helvetica, sans-serif;
      font-size : 10pt;
      font-weight : bold;
      padding-left: 10px;
      background-color: #d5d5d5;
      max-width: 200px;
      overflow:hidden;
      white-space: nowrap;
      color: #666666;
}

/* ----------------------------------------------------------------------------
 * Dialogs
 */

.group {
      margin: 0 0.5em 0.5em 0.5em;
      padding: 0.3em 0.3em 0.3em 0.3em;
      border-color: #000000;
      border-style: solid;
      border-width: 1px;
      text-align: center;
}

.groupCaption {
      color : #80a0e0;
      text-decoration : none;
      font-size : 11pt;
      font-weight : bold;
      font-family : Arial, Helvetica, sans-serif;
}

table.dialogTable {
      background-color: #ffffff;
      white-space: nowrap;
      border-width: 0px;
      text-align: left;
      vertical-align: middle;
}

table.center {
      margin-left: auto;
      margin-right: auto;
}

/* ----------------------------------------------------------------------------
 * Message Boxes
 */

.noframebox {
      padding: 0.3em;
}

.framebox {
      padding: 0.3em;
      border-style: solid;
      border-color: #000000;
      border-width: 1px;
}

.nowrap { white-space: nowrap; }
.wrap { white-space: normal; }

.uppercase { text-transform:uppercase; }

.authHeading {
      color : #000000;
      text-decoration : none;
      font-size : 11pt;
      font-weight : bold;
      font-family : Arial, Helvetica, sans-serif;
}

.authLogo {
      display: block;
}

.default {
      color : #0860A8;
      text-align: justify;
      text-decoration : none;
      font-size : 10pt;
      font-family : Arial, Helvetica, sans-serif;
}

.notice {
      color : #a51924;
      align: center;
      text-align: center;
      text-decoration : none;
      font-size : 11pt;
      font-family : Arial, Helvetica, sans-serif;
      width:400px;
}

.error {
        color: #ff0000;
	text-decoration : none;
	font-size : 11pt;
	font-weight : bold;
	font-family : Arial, Helvetica, sans-serif;
}

.tiny {
	text-decoration : none;
	font-size : 8pt;
	font-family : Arial, Helvetica, sans-serif;
}

.normal, .elem_l, .elem_r, .settings_fieldname_checkbox_en, .settings_fieldname_checkbox, .settings_fieldname, .settings_field, .notice {
	text-decoration : none;
	font-size : 10pt;
	font-family : Arial, Helvetica, sans-serif;
}

.notice { 
        text-align: center; 
}

.mono { 
	font-family: monospace;
}

.bold {
	text-decoration : none;
	font-size : 10pt;
	font-weight : bold;
	font-family : Arial, Helvetica, sans-serif;
}

.emph   { font-weight : bold; }

.elem_l , .settings_fieldname_checkbox_en, .settings_fieldname_checkbox, .settings_fieldname { text-align: right; }
.elem_r,  .settings_field { text-align: left; }

.left   { text-align: left;   }
.center { text-align: center; }
.right  { text-align: right;  }

.buttons { text-align: center; }

.indent { padding-left: 16px; }

.main {
      background-color : #ffffff;
      color: #000000;
      font-size: 10pt;
      font-family: Arial, Helvetica, sans-serif;
}

/* frame displaying the help page */
.help {
      color: #000000;
      font-size: 10pt;
      font-family: Arial, Helvetica, sans-serif;
      background-image:url(web-mid-bg.gif);
      overflow:auto;
      margin: 0.5em 0.5em 0.5em 0.5em;
}

.help .headline {
      margin-top:1em;
      color: #000080;
      font-size: 20pt;
}
.help h1 {
      margin-top:3em;
      color: #000080;
      font-size: 17pt;
}
.help h2 {
      margin-top:2em;
      color: #2020a0;
      font-size: 15pt;
}
.help h3 {
      margin-top:1em;
      color: #404080;
      font-size: 12pt;
}
.help table.toc {
      /* indent the TOC entries */
      text-indent:3em;
}
.help table.opaque_cells td {
      background-color: #ffffff;
}


.rsp_message {
	color : #000000;
	text-decoration : none;
	text-align: center;
	font-size : 11pt;
	font-weight : bold;
	font-family : Arial, Helvetica, sans-serif;
	padding : 1em 0 1em 0;
}
/* 
 * Align table in rsp_message centered (table is used for formatting bulleted
 * list centered, but the bullets horizontally lined up)  
 */
.rsp_message table {
    margin-left:auto; margin-right:auto
}


.aclcolorno        { color : #800000; }
.aclcoloryes       { color : #008000; }
.aclcolornone      { color : #800000; }
.aclcolorview      { color : #409040; }
.aclcolorcontrol   { color : #008000; }
.aclcolordeny      { color : #800000; }
.aclcolorreadonly  { color : #409040; }
.aclcolorreadwrite { color : #008000; }

BODY {
	background-color : #ffffff;
	color : #000000;
	font-size : 10pt;
	font-family : Arial, Helvetica, sans-serif;
}

/* 
 * surrounding of the login page window 
 */
body.auth {
	background-color : #0860a8;
}

/*
 * table which will be maximized 
 * to the whole screen
 */
table.surroundingTable {
      height: 100%;
      width: 100%;
      text-align: center;
} 


/* 
 * title area on top of the window
 */
body.title {
      background-color : #0860a8;
}

body.title a {
      color : #ffffff;
}

HR {
      border: 0;
      color: #000000;
      background-color: #000000;
      height: 1px;
}

P {
	color : #000000;
	font-size : 10pt;
	font-family : Arial, Helvetica, sans-serif;
}

TABLE {
	background-repeat: no-repeat
}


/*
 * table with the login form elements
 */
table.authInner {
      background-color : #ffffff;
}

.cb_field {
      width: 40px;
}

/* ----------------------------------------------------------------------------
 * Event Log
 */

.loggingTable {
      color: #000000;
      text-decoration: none;
      font-size: 10pt;
      font-family: Arial, Helvetica, sans-serif;
}

.loggingRowOdd  { background-color : #e7e7e7; }
.loggingRowEven { background-color : #ffffff; }
.loggingHeader  { background-color : #d4d4d4; }

/*
 * tables surrounding the form elements
 * and their cells
 */
table.pagetable {
      border-spacing : 0px;
}
table.pagetable tr td {
      background-color : #ffffff;
      padding : 5px;
}


TABLE.inner {
      background-color: #ffffff;
}

/*
 * standard table
 */
.stdtable th {padding-right: 10px;padding-left: 10px;}
.stdtable td {padding-right: 10px;padding-left: 10px;}

/* 
 * Some special definitions for colors not used in the web
 * pages but other parts of the software, to avoid using
 * a special file or other configuration method.
 * Important!
 * Leave the structure as is, just change the color, use
 * the standard 6 digit notation
 */
.specialcolor_cornerbg { color: #0860a8; }
.specialcolor_cornerfg { color: #ffffff; }
.specialcolor_telnetbg { color: #ffffff; }
.specialcolor_telnetfg { color: #000000; }
.specialcolor_sshbg { color: #ffffff; }
.specialcolor_sshfg { color: #000000; }

/*-----------------------------------------------------------------------------------------------------
	Misc
-----------------------------------------------------------------------------------------------------*/

a.infobutton span { visibility:hidden; 
                    position:absolute;
                    padding:1em;
                    text-decoration:none; 
}
a.infobutton:hover span { visibility:visible;
                          border:1px solid #0076cc;
                          color:black;
                          background:white;
}


/*-----------------------------------------------------------------------------------------------------
	Screenshot
-----------------------------------------------------------------------------------------------------*/

.screenshot_wrapper, .screenshot_wrapper a {
        text-decoration : none;
}

.screenshot, .screenshot a, a.screenshot {
        color: #ffffff;
        text-align: left;
        text-decoration : none;
        font-size : 20pt;
        font-weight : bold;
        font-family : Arial, Helvetica, sans-serif;
        background-color : #0000ff;
        width : 320px;
        height : 240px;
        padding-right: 15px;
        padding-left: 15px;
        padding-top: 15px;
        padding-bottom: 15px;
        cursor : pointer;
        white-space: normal;
}

