#define PDU_BGCOLOR #cccccc
#define PDU_BORDERCOLOR #000000
#define PDU_BORDERWIDTH 3

#define RPC_CRIT_BGCOLOR #ff6252
#define RPC_NON_CRIT_BGCOLOR #ffe762
#define RPC_OK_BGCOLOR #59e759

#bigdef PRINT_OUTLET_STATUS(__outlet_number__)
    led_state = getVarByIdx("outlet_led_state", __outlet_number__);
    outlet_name = getVarByIdx("outlet_name", __outlet_number__);
    write('<td bgcolor=PDU_BGCOLOR align=center valign=bottom>' +
           '<table class="tmpl_tab" border=0 cellpadding="2" cellspacing="0">' +
            '<tr>' +
             '<td align=center bgcolor=PDU_BGCOLOR><b>' + outlet_name + '</b></td>'+
            '</tr>' +
            '<tr>' +
             '<td align=center valign=middle bgcolor=PDU_BGCOLOR>' +
              '<a href="outlet_detail.asp?__target_outlet__=' +
               __outlet_number__ +
               '">' +
               '<img src="images/led_' + led_state + '.gif"' +
               ' title="' + led_state + '" border=0>' +
               __outlet_number__ +
              '</a>' +
             '</td>' +
            '</tr>' +
            '<tr>' +
             '<td align=center bgcolor=PDU_BGCOLOR>');
              imgButton(T_("On"), "switch_on", "target_switch_on_" + __outlet_number__);
              imgButton(T_("Off"), "switch_off", "target_switch_off_" + __outlet_number__);
    write(   '</td>' +
            '</tr>' +
           '</table>' +
          '</td>\n');
    if (aclHasPermission("outlet_" + (__outlet_number__ - 1), "yes") != "yes") {
        write('<script type="text/javascript"><!--\n' +
              'var onButton = getElement("name", "action_target_switch_on_' +
              __outlet_number__ +
              '", 0);\n' +
              'var offButton = getElement("name", "action_target_switch_off_' +
              __outlet_number__ +
              '", 0);\n' +
              'onButton.disabled = offButton.disabled = true;\n' +
              'onButton.title = offButton.title = "' + T_("Permission denied.") + '";\n' +
              '//--></script>\n');
    }
#endbigdef /* PRINT_OUTLET_STATUS */

#bigdef PRINT_SENSOR_STATUS(__outlet__, __sensor_number__, __alt_name__)
    <%
    sensor_number = rpcGetSensorNumber(__outlet__, __sensor_number__);
    rpcInitSensorState(sensor_number);
    if (__alt_name__ == "") {
        sensor_name = getVarByIdx("sensor_name", sensor_number);
    } else {
        sensor_name = __alt_name__;
    }
    sensor_value = getVarByIdx("sensor_value", sensor_number);
    sensor_unit = getVarByIdx("sensor_unit", sensor_number);
    write('<td>' +
           '<table class="tmpl_tab" border=0 cellpadding="2" cellspacing="0">' +
            '<tr>' +
             '<td>' +
              sensor_name +
             '</td>' +
            '</tr>' +
            '<tr>' +
             '<td>' +
              sensor_value +
              ' ' +
              sensor_unit +
             '</td>' +
            '</tr>' +
           '</table>' +
          '</td>\n');
    %>
#endbigdef /* PRINT_SENSOR_STATUS */

#bigdef TARGET_OUTLET_SELECT_LIST(__label__)
#comment target principal template should not affect _show_apply
<% __show_apply = _show_apply; %>
#define __t__ TEMPLATE_TARGET_LIST
TMPL_BEGIN()
DIALOGTABLE_BEGIN()
  <tr>
    <td class="settings_fieldname bold">__label__
      DIALOGTABLE_SPACER()
      <select name="__target_outlet__" onchange="getElement('name', 'action_target_outlet_update', 0).click()">
        <% for (i = 1; i <= rpcGetNumOutlets(); i++) {
	       if (i == __target_outlet__) {
                   _sel = " selected";
               } else {
                   _sel = "";
               }
               _outlet_name = rpcGetOutletName(i);
	       write('<option value="' + i + '"' + _sel + '>' + 
                     _outlet_name + ' (' + i + ')\n');
           }
        %>
      </select>
      &nbsp;
      SUBMIT_BUTTON(T_("Update"), "update", "target_outlet_update", "")
    </td>
  </tr>
DIALOGTABLE_END()
TMPL_END()
<% _show_apply = __show_apply; %>
#endbigdef

#bigdef _SENSOR_GET_THRESHOLDS_LOWER
    sensor_threshold_lnc = getVarByIdx("sensor_threshold_lnc", i);
    sensor_threshold_lc = getVarByIdx("sensor_threshold_lc", i);
#endbigdef /* SENSOR_GET_THRESHOLDS_LOWER */

#bigdef _SENSOR_GET_THRESHOLDS_UPPER
    sensor_threshold_unc = getVarByIdx("sensor_threshold_unc", i);
    sensor_threshold_uc = getVarByIdx("sensor_threshold_uc", i);
#endbigdef /* SENSOR_GET_THRESHOLDS_UPPER */

#define __SENSOR_THRESHOLDS_INPUT(__fv__, __color__) \
    "<td class=\"dtbl_record\" bgcolor=__color__><input", isDisabledStr(__fv__, sensor_id), "type=text", \
     "name='real_##__fv__##_rpcoutset__FV_VEC_IDX_DELI__" + sensor_id + \
     "' maxlength=6 size=5 bgcolor=__color__ value='" + \
     getVarByIdx('real_##__fv__##_rpcoutset', sensor_id) + "'></td>"
// defaults?

#define _SENSOR_THRESHOLDS_INPUTS_EMPTY \
    '<td class="dtbl_record" colspan=2></td>'
#define _SENSOR_THRESHOLDS_INPUTS_EMPTY_green \
    '<td class="dtbl_record" bgcolor=RPC_OK_BGCOLOR colspan=2></td>'

#define _SENSOR_THRESHOLDS_INPUTS_LOWER \
    __SENSOR_THRESHOLDS_INPUT(FV_ID_RPC_SETUP_LC, RPC_CRIT_BGCOLOR), \
    __SENSOR_THRESHOLDS_INPUT(FV_ID_RPC_SETUP_LNC, RPC_NON_CRIT_BGCOLOR)

#define _SENSOR_THRESHOLDS_INPUTS_UPPER \
    __SENSOR_THRESHOLDS_INPUT(FV_ID_RPC_SETUP_UNC, RPC_NON_CRIT_BGCOLOR), \
    __SENSOR_THRESHOLDS_INPUT(FV_ID_RPC_SETUP_UC, RPC_CRIT_BGCOLOR)

#bigdef SENSOR_THRESHOLDS_GENERIC(__lower__, __upper__)
    write('<input type="hidden" name="sensor_' + sensor_id +'_enabled" value="1">\n');
    write("<script>table_entry_begin();</script>");
    write('<td class="dtbl_record">', sensor_name, '</td>');
    write(__lower__);
    write('<td class="dtbl_record"></td>');
    write(__upper__);
    write("<script>table_entry_end();</script>");
#endbigdef /* SENSOR_THRESHOLDS_GENERIC */
#bigdef SENSOR_THRESHOLDS_GENERIC_green(__lower__, __upper__)
    write('<input type="hidden" name="sensor_' + sensor_id +'_enabled" value="1">\n');
    write("<script>table_entry_begin();</script>");
    write('<td class="dtbl_record">', sensor_name, '</td>');
    write(__lower__);
    write('<td class="dtbl_record" bgcolor=RPC_OK_BGCOLOR></td>');
    write(__upper__);
    write("<script>table_entry_end();</script>");
#endbigdef /* SENSOR_THRESHOLDS_GENERIC */

#bigdef SENSOR_THRESHOLDS_BOTH
    _SENSOR_GET_THRESHOLDS_LOWER
    _SENSOR_GET_THRESHOLDS_UPPER
    
    SENSOR_THRESHOLDS_GENERIC(_SENSOR_THRESHOLDS_INPUTS_LOWER, _SENSOR_THRESHOLDS_INPUTS_UPPER)
#endbigdef /* SENSOR_THRESHOLDS_BOTH */
 
#bigdef SENSOR_THRESHOLDS_LOWER
    _SENSOR_GET_THRESHOLDS_LOWER
    
    SENSOR_THRESHOLDS_GENERIC(_SENSOR_THRESHOLDS_INPUTS_LOWER, _SENSOR_THRESHOLDS_INPUTS_EMPTY)
#endbigdef /* SENSOR_THRESHOLDS_LOWER */

#bigdef SENSOR_THRESHOLDS_UPPER
    _SENSOR_GET_THRESHOLDS_UPPER
    
    SENSOR_THRESHOLDS_GENERIC(_SENSOR_THRESHOLDS_INPUTS_EMPTY, _SENSOR_THRESHOLDS_INPUTS_UPPER)
#endbigdef /* SENSOR_THRESHOLDS_UPPER */

#bigdef SENSOR_THRESHOLDS_EMPTY
    SENSOR_THRESHOLDS_GENERIC(_SENSOR_THRESHOLDS_INPUTS_EMPTY, _SENSOR_THRESHOLDS_INPUTS_EMPTY)
#endbigdef /* SENSOR_THRESHOLDS_EMPTY */

