;
; (c) Peppercon AG, Zwickau, Rolf Kampffmeyer November 2005
;
;  generate pushbuttons for belkin frontend,
;  register-tabs (headers and link-buttons)
;
; Run: copy this file into your home/.gimp-2.0/scripts
;      start gimp
;      select menu->Xtns->"All Belkin buttons n stuff"
;      the images will be created in the directory where gimp was started
;      
; When modifying the file you can also select Gimp menu->Xtns->Script
; Fu->refresh (german: "Auffrischen") to reload the script.
;
; I (Rolf) didn't run this script in batch mode.


(define (make-all-belkin-buttons)


(let* (
       (menu-names '(
; Remote Control
		     "KVM Console"
		     "Remote Power"
;		     "Power Switch Status"
		     "Telnet Console"
		     "Server Event Log"
		     "Server Health"
;Virtual Media
		     "Floppy Disk"
		     "CD-ROM Image"
		     "Drive Redirection"
		     "Options"
;User Management
		     "Change Password"
		     "Users & Groups"
		     "Permissions"
;KVM Settings
		     "User Console"
		     "Power Control"
		     "Keyboard/Mouse"
		     "Video"
		     "KVM Ports"
;Device Settings
		     "Network"
		     "Dynamic DNS"
		     "Security"
		     "Certificate"
		     "Serial Port"
		     "IPMI"
		     "Date/Time"
		     "Authentication"
		     "Event Log"
		     "SNMP Settings"
; Maintenance
		     "Device Information"
		     "Event Log"
		     "Update Firmware"
		     "Unit Reset"
		     ))
       (menu-files '(
; Remote Control
		     "kvm_console"
		     "remote_power"
;		     "power_switch_status"
		     "telnet_console"
		     "server_event_log"
		     "server_health"
;Virtual Media
		     "floppy_disk"
		     "cd_rom_image"
		     "drive_redirection"
		     "options"
;UserManagement
		     "change_password"
		     "users_groups"
		     "permissions"
;KVM Settings
		     "user_console"
		     "power_control"
		     "keyboard_mouse"
		     "video"
		     "kvm_ports"
;Device Settings
		     "network"
		     "dynamic_dns"
		     "security"
		     "certificate"
		     "serial_port"
		     "ipmi"
		     "date_time"
		     "authentication"
		     "device_event_log"
		     "snmp_settings"
;Maintenance
		     "device_information"
		     "maintenance_event_log"
		     "update_firmware"
		     "unit_reset"
		     )))
  (make-all-menu-buttons menu-names menu-files)
  )

; make register card headers
   (let* (
 	 (tab-names '("Remote Control" "Virtual Media" "User Management" 
 		      "KVM Settings" "Device Settings" "Maintenance"))
 	 (tab-filenames '("remote_control" "virtual_media" "user_management" 
 			  "kvm_settings" "device_settings" "maintenance")))
     (make-all-register-card-headers tab-names tab-filenames)
     ); let*

; make the round pushbuttons
(let* (
       (names '("Home" "Help" "Logout" "Login" "Apply" "Apply Changes"
		"Short Press" "Long Press" "Reset" "Lookup" "More Entries"
		"Update" "Upload" "Download" "Re-Activate"
		"Set" "Create" "Modify" "Delete" "Switch" "Append" "Insert" 
		"Replace" "Clear" "Discard" "Really Reset" "Really Clear" 
		"Cancel" "Clear Changes" "Power On" "Power Off" 
		"Clear Event Log" "Get State" "Sequence On" "Sequence Off" 
		"Move Up" "Move Down" "<" ">"
		"Copy" "Unblock" "Refresh"
		))
       (filenames '(
		"home" "help" "logout" "login" "apply" "apply_changes"
		"short_press" "long_press" "reset" "lookup" "mentries"
		"update" "upload" "download" "reactivate"
		"set" "create" "modify" "delete" "switch" "append" "insert" 
		"replace" "clear" "discard" "r_reset" "r_clear" 
		"cancel" "clear_changes" "poweron" "poweroff"
		"clear_event_log" "get_state" "seq_on" "seq_off" 
		"up" "down" "leftarrow" "rightarrow"
		"copy" "unblock" "refresh"

		))
       )
  (make-all-round-buttons names filenames)
) 
; (make-belkin-round-button "Buuuuuuuuuh" "buuh_muell")
)

(define (make-all-menu-buttons menu-names menu-files)
   (while (car menu-names)
 	 (make-belkin-menu-button (car menu-names) (car menu-files) )
 	 (set! menu-names (cdr menu-names))
 	 (set! menu-files (cdr menu-files))
 	 )
)
(define (make-all-register-card-headers tab-names tab-filenames)
     (while (car tab-names)
 	   (make-belkin-menu-tab (car tab-names) (car tab-filenames))
 	   (set! tab-names (cdr tab-names))
 	   (set! tab-filenames (cdr tab-filenames))  ); while
)
(define (make-all-round-buttons names filenames)
     (while (car names)
 	   (make-belkin-round-button (car names) (car filenames))
 	   (set! names (cdr names))
 	   (set! filenames (cdr filenames))  ); while
)

(define (make-belkin-menu-tab text filename)
  (let* (
	 (font "Sans Bold")
	 (fontsize 12)
	 (inactive_text '(100 100 200))
	 (active_text '(255 255 255))
	 (RUN-NONINTERACTIVE 1)
	 (TRANSPARENT-FILL 3)
	 (INDEXED-IMAGE 4)
	 )

; make the inactive tab
    (set! image (car (gimp-file-load RUN-NONINTERACTIVE 
				     "blank_tab1.gif" "blank_tab1.gif")))
    (set! width (car (gimp-image-width image)))
    (set! height (car (gimp-image-height image)))
    (set! layer (car (gimp-layer-new image width height RGB-IMAGE
				      "mylayer" 100 NORMAL-MODE)))
    (gimp-layer-add-alpha layer)
    (gimp-drawable-fill layer TRANSPARENT-FILL)
    (gimp-convert-rgb image)
    (gimp-image-add-layer image layer 0)
    (gimp-palette-set-foreground inactive_text)
    (gimp-text-fontname image layer 13 15 text -1 TRUE fontsize 1 font)
    (gimp-image-merge-visible-layers image CLIP-TO-IMAGE) 
    (gimp-image-convert-indexed image 1 0 255 0 1 "")
    (gimp-file-save 1 image layer 
		    (string-append "tab_" (string-append filename "1.gif"))
		    (string-append "tab_" (string-append filename "1.gif"))
		    )
;    (gimp-display-new image)
    (gimp-image-delete image)

; Make the active tab
    (set! image (car (gimp-file-load RUN-NONINTERACTIVE 
				     "blank_tab2.gif" "blank_tab2.gif")))
    (set! width (car (gimp-image-width image)))
    (set! height (car (gimp-image-height image)))
    (set! layer (car (gimp-layer-new image width height RGB-IMAGE
				      "mylayer" 100 NORMAL-MODE)))
    (gimp-layer-add-alpha layer)
    (gimp-drawable-fill layer TRANSPARENT-FILL)
    (gimp-convert-rgb image)
    (gimp-image-add-layer image layer 0)
    (gimp-palette-set-foreground active_text)
    (gimp-text-fontname image layer 13 15 text -1 TRUE fontsize 1 font)
    (gimp-image-merge-visible-layers image CLIP-TO-IMAGE) 
    (gimp-image-convert-indexed image 1 0 255 0 1 "")
    (gimp-file-save 1 image layer 
		    (string-append "tab_" (string-append filename "2.gif"))
		    (string-append "tab_" (string-append filename "2.gif"))
		    )
;    (gimp-display-new image)
    (gimp-image-delete image)

; make the tab where the tab above it is active
    (set! image (car (gimp-file-load RUN-NONINTERACTIVE 
				     "blank_tab3.gif" "blank_tab3.gif")))
    (set! width (car (gimp-image-width image)))
    (set! height (car (gimp-image-height image)))
    (set! layer (car (gimp-layer-new image width height RGB-IMAGE
				      "mylayer" 100 NORMAL-MODE)))
    (gimp-layer-add-alpha layer)
    (gimp-drawable-fill layer TRANSPARENT-FILL)
    (gimp-convert-rgb image)
    (gimp-image-add-layer image layer 0)
    (gimp-palette-set-foreground inactive_text)
    (gimp-text-fontname image layer 13 15 text -1 TRUE fontsize 1 font)
    (gimp-image-merge-visible-layers image CLIP-TO-IMAGE) 
    (gimp-image-convert-indexed image 1 0 255 0 1 "")
    (gimp-file-save 1 image layer 
		    (string-append "tab_" (string-append filename "3.gif"))
		    (string-append "tab_" (string-append filename "3.gif"))
		    )
;    (gimp-display-new image)
    (gimp-image-delete image)

    )
)

(define (make-belkin-menu-button text filename)
  (let* (
	 (inactive_text '(111 111 111))
	 (active_text '(225 255 100))
	 (inactive_background '(200 200 200))
	 (active_background '(100 100 200))
	 (active_background_inactive_text '(240 240 255))
	 (font "Sans")
	 (fontsize 9)
	 (width 154)
	 (height 12)
	 (image  (car (gimp-image-new width height RGB)))
	 (layer  (car (gimp-layer-new image width height RGB-IMAGE "mylayer" 100 NORMAL-MODE)))
	 (WHITE-FILL 2)
	 (CLIP-TO-IMAGE 1)
	)
; drei arten von Knoepfe: inaktiv (hintergrund und vordergrund), reiter aktiv-schrift-inaktiv, reiter activ -- schrift aktiv.

;    1. Create an new image
;    2. Create a text layer
;    3. Duplicate the text layer
;    4. Enlarge the bottom text layer
;    5. Fill both text layers with a gradient
;    6. Merge the text layers
;    7. Apply a drop shadow
;    8. Merge all layers
;    9. Auto-crop the image

       (gimp-image-add-layer image layer 0)
       (gimp-palette-set-background inactive_background)
       (gimp-palette-set-foreground inactive_text)
       (gimp-drawable-fill layer BG-IMAGE-FILL)
;       (print image)

       (gimp-text-fontname image layer 20 -1 text -1 TRUE fontsize 1 font)
       (gimp-image-merge-visible-layers image CLIP-TO-IMAGE) 

       ; make 4 pixel white box on the left
       (gimp-rect-select image 0 0 4 height 2 0 0)
       (gimp-edit-fill layer WHITE-FILL)
       (gimp-selection-all image)

       ; save image 
       (gimp-image-convert-indexed image 1 0 255 0 1 "")
       (gimp-file-save 1 image layer (string-append filename "_off.gif")
		       (string-append filename "_off.gif")
		       )
;       (gimp-display-new image)

       ; make menu entry with active background and black text
       (gimp-image-delete image)
       (set! image2 (car (gimp-image-new width height RGB)))
       (set! layer2  (car (gimp-layer-new image2 width height RGB-IMAGE "mylayer" 100 NORMAL-MODE)))
       (gimp-image-add-layer image2 layer2 0)
       (gimp-palette-set-background active_background)       
       (gimp-palette-set-foreground active_background_inactive_text)
       (gimp-drawable-fill layer2 BG-IMAGE-FILL)

       (gimp-text-fontname image2 layer2 20 -1 text -1 TRUE fontsize 1 font)
       (gimp-image-merge-visible-layers image2 CLIP-TO-IMAGE) 

       ; make 4 pixel white box on the left
       (gimp-rect-select image2 0 0 4 height 2 0 0)
       (gimp-edit-fill layer2 WHITE-FILL)
       (gimp-selection-all image2)
       ; save image2 
       (gimp-image-convert-indexed image2 1 0 255 0 1 "")
       (gimp-file-save 1 image2 layer2 (string-append filename "_on.gif")
 		       (string-append filename "_on.gif")
 		       )
;       (gimp-display-new image2)


       ; make menu entry with active background and active text
       (gimp-image-delete image2)
       (set! image3 (car (gimp-image-new width height RGB)))
       (set! layer3  (car (gimp-layer-new image3 width height RGB-IMAGE "mylayer" 100 NORMAL-MODE)))
       (gimp-image-add-layer image3 layer3 0)
       (gimp-palette-set-background active_background)       
       (gimp-palette-set-foreground active_text)
       (gimp-drawable-fill layer3 BG-IMAGE-FILL)

       (gimp-text-fontname image3 layer3 20 -1 text -1 TRUE fontsize 1 font)
       (gimp-image-merge-visible-layers image3 CLIP-TO-IMAGE) 

       ; make 4 pixel white box on the left
       (gimp-rect-select image3 0 0 4 height 2 0 0)
       (gimp-edit-fill layer3 WHITE-FILL)
       (gimp-selection-all image3)
       ; save image3 
       (gimp-image-convert-indexed image3 1 0 255 0 1 "")
       (gimp-file-save 1 image3 layer3 (string-append filename "_ylw.gif")
 		       (string-append filename "_ylw.gif")
 		       )
;       (gimp-display-new image3)
       (gimp-image-delete image3)


  ); let*
); make-belkin-menu-button

(define (make-belkin-round-button text filename)

; This does the same as do-my-pubibutton, but I wrote it from scratch
; instead of crippling down the 3d-button-scriptf-fu

  (let* (
	 (font "Sans Bold")
	 (fontsize 14)
	 (extents (gimp-text-get-extents-fontname text fontsize 0 font))
	 ; extents == (width height ascent descent)
	 (width (+ 40 (car extents)))
	 (height 24)
	 (white '(255 255 255))
	 (button-color '(120 120 240))
	 (text-color white)
	 (feather-type 1)
	 (feather-radius 27)
	 (image (car (gimp-image-new width height RGB)))
	 (layer (car (gimp-layer-new image width height RGB-IMAGE
				     "mylayer" 100 NORMAL-MODE)))
	 (WHITE-FILL 2)
	 (CLIP-TO-IMAGE 1)
	 (CHANNEL-OP-REPLACE 2)
	 (FG-BUCKET-FILL 0)
	 (NORMAL-MODE 0)
	 (NON-INTERACTIVE 1)
	 )
    (gimp-image-add-layer image layer 0)
    (gimp-palette-set-background white)
    (gimp-palette-set-foreground button-color)
    (gimp-drawable-fill layer WHITE-FILL)
    
    (gimp-rect-select image 2 2 (- width 4) (- height 4) 
		      CHANNEL-OP-REPLACE feather-type feather-radius)
;    (script-fu-selection-round NON-INTERACTIVE image layer round-radius)
; this script is garbage.
    (gimp-selection-sharpen image)
    (gimp-selection-feather image 2)
    (gimp-edit-bucket-fill layer FG-BUCKET-FILL NORMAL-MODE 100 0 FALSE 0 0)

    (if (< height (cadr extents)) (error-error-error-BOOM))
    (set! x (/ (- width (car extents)) 2))
    (set! y (/ (- height (cadr extents)) 2))

    (gimp-selection-all image)
    (gimp-palette-set-foreground text-color)
    (gimp-text-fontname image layer x y text 0 TRUE fontsize 0 font)
  
    (gimp-selection-none image)
    (gimp-image-merge-visible-layers image CLIP-TO-IMAGE)
    (gimp-image-convert-indexed image 1 0 255 0 1 "")
    (gimp-file-save 1 image layer 
		    (string-append "button_" 
				   (string-append filename ".en.gif"))
		    (string-append "button_" 
				   (string-append filename ".en.gif"))
		    )
    (gimp-image-delete image)
;    (gimp-display-new image)
    ); let*

)

(script-fu-register "make-all-belkin-buttons"
		    _"<Toolbox>/Xtns/_All Belkin buttons n stuff..."
		    "Belkin buttons n stuff"
		    "bla"
		    "Rolf Kampffmeyer"
		    "November 2005"
		    ""
)
