/**
 * \file bmc_dev_chassis.h
 *
 * Description: BMC Chassis Device
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __BMC_DEV_CHASSIS_H__
#define __BMC_DEV_CHASSIS_H__

/**
 * Initializes the BMC Chassis device and registers it at the BMC core.
 *
 * @return PP_SUC (0) if success
 *         PP_ERR (-1) if error
 */
int pp_bmc_dev_chassis_init(void);

/**
 * Finishes the BMC Chassis device and unregisters it at the BMC core.
 */
void pp_bmc_dev_chassis_cleanup(void);

#endif /* !__BMC_DEV_CHASSIS_H__ */
