/**
 * \file bmc_dev_event.h
 *
 * Description: BMC Event Device
 *
 * (c) 2005 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __BMC_DEV_EVENT_H__
#define __BMC_DEV_EVENT_H__

/**
 * Initializes the BMC Event device and registers it at the BMC core.
 *
 * @return PP_SUC (0) if success
 *         PP_ERR (-1) if error
 */
int pp_bmc_dev_event_init(void);

/**
 * Finishes the BMC Event device and unregisters it at the BMC core.
 */
void pp_bmc_dev_event_cleanup(void);

#endif /* !__BMC_DEV_EVENT_H__ */
