/**
 * \file bmc_dev_fru.h
 *
 * Description: BMC Field Replaceable Unit Inventory Device
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __BMC_DEV_FRU_H__
#define __BMC_DEV_FRU_H__

/**
 * Initializes the BMC FRU Inventory device and registers it at the BMC core.
 *
 * @return PP_SUC (0) if success
 *         PP_ERR (-1) if error
 */
int pp_bmc_dev_fru_init(void);

/**
 * Finishes the BMC FRU Inventory device and unregisters it at the BMC core.
 */
void pp_bmc_dev_fru_cleanup(void);

#endif /* !__BMC_DEV_FRU_H__ */
