/**
 * \file bmc_dev_kvm.h
 *
 * Description: BMC OEM Device (Peppercon KVM)
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __BMC_DEV_KVM_H__
#define __BMC_DEV_KVM_H__

/**
 * Initializes the BMC KVM device and registers it at the BMC core.
 *
 * @return PP_SUC (0) if success
 *         PP_ERR (-1) if error
 */
int pp_bmc_dev_kvm_init(void);

/**
 * Finishes the BMC KVM device and unregisters it at the BMC core.
 */
void pp_bmc_dev_kvm_cleanup(void);


#endif /* !__BMC_DEV_KVM_H__ */
