/**
 * bmc_dev_pef.h
 *
 * BMC Platform Event Filtering (PEF), IPMI command frontend
 * This module only gets and sets parameters and forwards some
 * notifications on parameter changes. There is not one piece
 * of internal logic in this file.
 *
 * (c) 2004 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef __BMC_DEV_PEF_H__
#define __BMC_DEV_PEF_H__

/**
 * Initializes the BMC SEL device and registers it at the BMC core.
 *
 * @return PP_SUC (0) if success
 *         PP_ERR (-1) if error
 */
int pp_bmc_dev_pef_init(void);

/**
 * Shutdown the BMC SEL device and unregister it at the BMC core.
 */
void pp_bmc_dev_pef_cleanup(void);

#endif

