/**
 * bmc_dev_sensor.h
 *
 * BMC sensor device 
 * 
 * (c) 2004 Peppercon AG, 12/14/2004, tbr@peppecon.de
 */

#ifndef __BMC_DEV_SENSOR_H__
#define __BMC_DEV_SENSOR_H__

#include <pp/bmc/sensor.h>
#include <pp/bmc/tp_ipmi_sens.h>

/********************************************************************
 * sensor devices c'tor/d'tor
 */

int pp_bmc_dev_sensor_init(void);

void pp_bmc_dev_sensor_cleanup(void);

/**
 * Callback for the sensor library to report new object. If the object is
 * a pp_tp_ipmi_sensor_t, it will be passed to the sensor_config_addsensor
 * function to add it to the bmc sensor devices.
 */
void pp_bmc_dev_sensor_add_object(pp_tp_obj_t* obj);

pp_tp_ipmi_sens_t* get_sensor_by_index(unsigned char idx);

#if defined (PP_FEAT_IPMI_THRESHOLD_PERSIST)
void pp_bmc_dev_sensor_init_thresholds(void);
#endif

#endif
