/**
 * bmc_chassis.h
 *
 * Tell the chassis commands the reset/power cycle cause.
 *
 * (c) 2005 Peppercon AG, 2005/9/13, roka@peppercon.de
 */

#ifndef __PP_BMC_CHASSIS_H__
#define __PP_BMC_CHASSIS_H__


/**
 * Remembers the initiator of a reboot, power cycle or power off and
 * invalidates the "boot commands valid flag" unless this is disabled.
 *
 * @param action 
 * @param source (e.g. pushbutton, PEF, watchdog)
 * @param channel
 */
void pp_bmc_dev_chassis_set_restart_cause(int action, unsigned char source, 
					  unsigned char channel);

#endif // __PP_BMC_CHASSIS_H__
