/**
 * \file ipmi_chan.h
 *
 * Description: IPMI Channels
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __IPMI_CHAN_H__
#define __IPMI_CHAN_H__

/*
 * Channel numbers
 */

#define IPMI_CHAN_PRIMARY_IPMB 0x0
#define IPMI_CHAN_LAN          0x1
#define IPMI_CHAN_SECDARY_IPMB 0x2
#define IPMI_CHAN_SERIAL       0x5
#define IPMI_CHAN_SCSI         0xa // proprietary IPMI-over-SCSI channel

#if defined(PP_FEAT_BAYTECH_2_IPMI)
#define IPMI_CHAN_LOOP_BAYTECH 0xb // local loop for baytech adapter
#endif /* PP_FEAT_BAYTECH_2_IPMI */

#define IPMI_CHAN_LOOP_SNMPD   0xc // local loop for snmpd 
#define IPMI_CHAN_LOOP_ERIC    0xd // local loop for eric  
#define IPMI_CHAN_PRESENT      0xe
#define IPMI_CHAN_SI           0xf
#define IPMI_CHAN_MAX          0xf

/*
 * Channel protocol types
 */
 
#define IPMI_CHAN_PROT_IPMB    0x01
#define IPMI_CHAN_PROT_ICMB    0x02
#define IPMI_CHAN_PROT_SMB     0x04
#define IPMI_CHAN_PROT_KCS     0x05
#define IPMI_CHAN_PROT_SMIC    0x06
#define IPMI_CHAN_PROT_BT10    0x07
#define IPMI_CHAN_PROT_BT15    0x08
#define IPMI_CHAN_PROT_TERM    0x09
#define IPMI_CHAN_PROT_SCSI    0x1c // OEM protocol: IPMI-over-SCSI

/*
 * Channel medium types
 */
 
#define IPMI_CHAN_MED_IPMB     0x01
#define IPMI_CHAN_MED_ICMB10   0x02
#define IPMI_CHAN_MED_ICMB09   0x03
#define IPMI_CHAN_MED_LAN      0x04
#define IPMI_CHAN_MED_SERIAL   0x05
#define IPMI_CHAN_MED_OTHERLAN 0x06
#define IPMI_CHAN_MED_PCISMB   0x07
#define IPMI_CHAN_MED_SMB1     0x08
#define IPMI_CHAN_MED_SMB2     0x09
#define IPMI_CHAN_MED_USB1     0x0a
#define IPMI_CHAN_MED_USB2     0x0b
#define IPMI_CHAN_MED_SI       0x0c
#define IPMI_CHAN_MED_SCSI     0x60 // OEM medium type: IPMI-over-SCSI

/*
 * Channel session support
 */

#define IPMI_CHAN_SESS_LESS     0x00 /* channel is session-less */
#define IPMI_CHAN_SESS_SINGLE   0x01 /* channel is single-session */
#define IPMI_CHAN_SESS_MULTI    0x02 /* channel is multi-session */
#define IPMI_CHAN_SESS_SESSION  0x03 /* channel is session-based */

/*
 * Channel access modes (3 bit)
 */
#define IPMI_CHAN_ACCESS_DISABLE  0x00
#define IPMI_CHAN_ACCESS_PREBOOT  0x01
#define IPMI_CHAN_ACCESS_ALWAYS   0x02
#define IPMI_CHAN_ACCESS_SHARED   0x03

#endif /* !__IPMI_CHAN_H__ */
