/**
 * \file ipmi_cmd.h
 *
 * Description: IPMI Network Functions and Command Codes
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __IPMI_CMD_H__
#define __IPMI_CMD_H__

#define IPMI_IS_REQUEST(netfn)  (((netfn) & 1) == 0)
#define IPMI_IS_RESPONSE(netfn) (((netfn) & 1) != 0)
#define IPMI_NETFN(netfn)       ((netfn) & 0x3e)

/*
 * Network functions
 */
 
#define IPMI_NETFN_CHASSIS      0x00
#define IPMI_NETFN_BRIDGE       0x02
#define IPMI_NETFN_SENSOR_EVENT 0x04
#define IPMI_NETFN_APP          0x06
#define IPMI_NETFN_FIRMWARE     0x08
#define IPMI_NETFN_STORAGE      0x0a
#define IPMI_NETFN_TRANSPORT    0x0c

/* extension */
#define IPMI_NETFN_OEM_QLOGIC       0x30
#define IPMI_NETFN_OEM_SUPERMICRO   0x30
#define IPMI_NETFN_OEM_MSI          0x32
#define IPMI_NETFN_OEM_MSI2         0x34
#define IPMI_NETFN_KVM		    0x36   /* is this available? */
#define IPMI_NETFN_OEM_ICP          0x38
#define IPMI_NETFN_OEM_PP	    0x3C   /* available? */
#define IPMI_NETFN_OEM_AMD	    0x3E

/*
 * App Device commands
 */

#define IPMI_CMD_GET_DEV_ID             0x01
#define IPMI_CMD_COLD_RESET             0x02
#define IPMI_CMD_WARM_RESET             0x03
#define IPMI_CMD_GET_SELF_TEST_RES      0x04
#define IPMI_CMD_SET_ACPI_POWER_STATE   0x06
#define IPMI_CMD_GET_ACPI_POWER_STATE   0x07
#define IPMI_CMD_GET_DEVICE_GUID        0x08

#define IPMI_CMD_SET_BMC_GLOBAL_ENABLES   0x2e
#define IPMI_CMD_GET_BMC_GLOBAL_ENABLES   0x2f
#define IPMI_CMD_CLEAR_MSG_FLAGS          0x30
#define IPMI_CMD_GET_MSG_FLAGS            0x31
#define IPMI_CMD_GET_MSG                  0x33
#define IPMI_CMD_SEND_MSG                 0x34
#define IPMI_CMD_READ_EVENT_MSG_BUFF      0x35
#define IPMI_CMD_GET_BT_INTERFACE_CAPS    0x36
#define IPMI_CMD_GET_SYSTEM_GUID          0x37
#define IPMI_CMD_MASTER_WRITE_READ        0x52
#define IPMI_CMD_GET_CHANNEL_CIPHER_SUITES    0x54
#define IPMI_CMD_GET_SYSTEM_INTERFACE_CAPABILITIES  0x57
/* App/Session */
#define IPMI_CMD_GET_CHANNEL_CAPABILITIES 0x38
#define IPMI_CMD_GET_SESSION_CHALLENGE    0x39
#define IPMI_CMD_ACTIVATE_SESSION         0x3a
#define IPMI_CMD_SET_SESSION_PRIVILEGE    0x3b
#define IPMI_CMD_CLOSE_SESSION            0x3c
#define IPMI_CMD_GET_SESSION_INFO         0x3d
/* Channel */
#define IPMI_CMD_SET_CHANNEL_ACCESS       0x40
#define IPMI_CMD_GET_CHANNEL_ACCESS       0x41
#define IPMI_CMD_GET_CHANNEL_INFO         0x42
/* User Mgmt */
#define IPMI_CMD_SET_USER_ACCESS        0x43
#define IPMI_CMD_GET_USER_ACCESS        0x44
#define IPMI_CMD_SET_USER_NAME          0x45
#define IPMI_CMD_GET_USER_NAME          0x46
#define IPMI_CMD_SET_USER_PASSWORD      0x47
/* RMCP+ Support/Payload */
#define IPMI_CMD_ACTIVATE_PAYLOAD                   0x48
#define IPMI_CMD_DEACTIVATE_PAYLOAD                 0x49
#define IPMI_CMD_GET_PAYLOAD_ACTIVATION_STATUS      0x4a
#define IPMI_CMD_GET_PAYLOAD_INSTANCE_INFO          0x4b
#define IPMI_CMD_SET_USER_PAYLOAD_ACCESS            0x4c
#define IPMI_CMD_GET_USER_PAYLOAD_ACCESS            0x4d
#define IPMI_CMD_GET_CHANNEL_PAYLOAD_SUPPORT        0x4e
#define IPMI_CMD_GET_CHANNEL_PAYLOAD_VERSION        0x4f
#define IPMI_CMD_GET_CHANNEL_OEM_PAYLOAD_INFO       0x50
#define IPMI_CMD_SUSPEND_RESUME_PAYLOAD_ENCRYPTION  0x55
#define IPMI_CMD_SET_CHANNEL_SECURITY_KEYS          0x56


/*
 * Chassis Device commands
 */

#define IPMI_CMD_GET_CHASSIS_CAPS           0x00
#define IPMI_CMD_GET_CHASSIS_STATE          0x01
#define IPMI_CMD_CHASSIS_CONTROL            0x02
#define IPMI_CMD_CHASSIS_RESET              0x03
#define IPMI_CMD_CHASSIS_IDENTIFY           0x04
#define IPMI_CMD_SET_CHASSIS_CAPS           0x05
#define IPMI_CMD_SET_POWER_RESTORE_POLICY   0x06
#define IPMI_CMD_GET_SYSTEM_RESTART_CAUSE   0x07
#define IPMI_CMD_SET_SYSTEM_BOOT_OPTIONS    0x08
#define IPMI_CMD_GET_SYSTEM_BOOT_OPTIONS    0x09
#define IPMI_CMD_SET_POWER_CYCLE_INTERVAL   0x0b
#define IPMI_CMD_GET_POH_COUNTER            0x0f

/*
 * Watchdog device commands
 */
 
#define IPMI_CMD_WATCHDOG_RESET     0x22
#define IPMI_CMD_WATCHDOG_SET       0x24
#define IPMI_CMD_WATCHDOG_GET       0x25

/*
 * Platform Event commands
 */

#define IPMI_CMD_PLATFORM_EVENT_MSG 0x02

/*
 * Platform Event Filtering commands
 */
 
#define IPMI_CMD_GET_PEF_CAPABILITES     0x10
#define IPMI_CMD_ARM_PEF_POSTPONE_TIMER  0x11
#define IPMI_CMD_SET_PEF_CONFIGURATION   0x12
#define IPMI_CMD_GET_PEF_CONFIGURATION   0x13
#define IPMI_CMD_SET_LASTPROCESSED_EVENT 0x14
#define IPMI_CMD_GET_LASTPROCESSED_EVENT 0x15
#define IPMI_CMD_ALERT_IMMEDIATE         0x16
#define IPMI_CMD_PET_ACKNOWLEDGE         0x17

/*
 * SEL Device commands
 */ 

#define IPMI_CMD_GET_SEL_INFO       0x40
#define IPMI_CMD_GET_SEL_ALLOC_INFO 0x41
#define IPMI_CMD_RESERVE_SEL        0x42
#define IPMI_CMD_GET_SEL_ENTRY      0x43
#define IPMI_CMD_ADD_SEL_ENTRY      0x44
#define IPMI_CMD_CLEAR_SEL          0x47
#define IPMI_CMD_GET_SEL_TIME       0x48
#define IPMI_CMD_SET_SEL_TIME       0x49

/*
 * FRU Inventory Device commands
 */ 

#define IPMI_CMD_GET_FRU_INV_AREA_INFO  0x10
#define IPMI_CMD_READ_FRU_DATA          0x11
#define IPMI_CMD_WRITE_FRU_DATA         0x12

/*
 * SDR Repository Device commands
 */ 

#define IPMI_CMD_GET_SDR_REPO_INFO          0x20
#define IPMI_CMD_RESERVE_SDR_REPO           0x22
#define IPMI_CMD_GET_SDR                    0x23
#define IPMI_CMD_ADD_SDR                    0x24
#define IPMI_CMD_CLEAR_SDR_REPO             0x27
#define IPMI_CMD_GET_SDR_REPO_TIME          0x28
#define IPMI_CMD_SET_SDR_REPO_TIME          0x29
#define IPMI_CMD_ENTER_SDR_REPO_UPDATE_MODE 0x2a
#define IPMI_CMD_EXIT_SDR_REPO_UPDATE_MODE  0x2b

/*
 * Sensor Device commands
 */

#define IPMI_CMD_GET_DEVICE_SDR_INFO        0x20
#define IPMI_CMD_GET_DEVICE_SDR             0x21
#define IPMI_CMD_RESERVE_DEVICE_SDR_REPO    0x22
#define IPMI_CMD_GET_SENSOR_READING_FACTORS 0x23
#define IPMI_CMD_SET_SENSOR_HYSTERESIS      0x24
#define IPMI_CMD_GET_SENSOR_HYSTERESIS      0x25
#define IPMI_CMD_SET_SENSOR_TRESHOLDS       0x26
#define IPMI_CMD_GET_SENSOR_TRESHOLDS       0x27
#define IPMI_CMD_SET_SENSOR_EVENT_ENABLE    0x28
#define IPMI_CMD_GET_SENSOR_EVENT_ENABLE    0x29
#define IPMI_CMD_REARM_SENSOR_EVENTS        0x2a
#define IPMI_CMD_GET_SENSOR_EVENT_STATUS    0x2b
#define IPMI_CMD_GET_SENSOR_READING         0x2d
#define IPMI_CMD_SET_SENSOR_TYPE            0x2e
#define IPMI_CMD_GET_SENSOR_TYPE            0x2f

/*
 * LAN Channel commands
 */
#define IPMI_CMD_SET_LAN_CONFIGURATION      0x01
#define IPMI_CMD_GET_LAN_CONFIGURATION      0x02
#define IPMI_CMD_SUSPEND_BMC_ARP            0x03

/*
 * Serial / Modem device commands
 */
#define IPMI_CMD_SET_SERIAL_MODEM_CONF          0x10
#define IPMI_CMD_GET_SERIAL_MODEM_CONF          0x11
#define IPMI_CMD_SET_SERIAL_MODEM_MUX           0x12
#define IPMI_CMD_GET_SERIAL_MODEM_TAP_RS        0x13
#define IPMI_CMD_SET_SERIAL_MODEM_PPP_UDP_TX    0x14
#define IPMI_CMD_GET_SERIAL_MODEM_PPP_UDP_TX    0x15
#define IPMI_CMD_SEND_SERIAL_MODEM_PPP_UDP_PKT  0x16
#define IPMI_CMD_GET_SERIAL_MODEM_PPP_UDP_RX    0x17
#define IPMI_CMD_SERIAL_MODEM_CONNECTION_ALIVE  0x18
#define IPMI_CMD_SERIAL_MODEM_CALLBACK          0x19
#define IPMI_CMD_SET_SERIAL_MODEM_USER_CB_OPTS  0x1A
#define IPMI_CMD_GET_SERIAL_MODEM_USER_CB_OPTS  0x1B

/*
 * KVM Device commands
 */ 

#define IPMI_CMD_RESET_KVM      0x01
#define IPMI_CMD_ENABLE_KVM     0x02
#define IPMI_CMD_DISABLE_KVM    0x03
#define IPMI_CMD_SET_KVM_DEST   0x04
#define IPMI_CMD_GET_KVM_DEST   0x05
#define IPMI_CMD_SET_KVM_OWNER  0x06
#define IPMI_CMD_GET_KVM_OWNER  0x07

/*
 * Serial/Modem Device commands
 */
#define IPMI_CMD_SOL_ACTIVATING    0x20
#define IPMI_CMD_SOL_SET_SOL_CFG   0x21
#define IPMI_CMD_SOL_GET_SOL_CFG   0X22

/*
 * MSI OEM commands
 */

/* IPMI_NETFN_OEM_MSI */
#define IPMI_CMD_MSI_DISABLE_SERIAL_PORT_SHARING    0x00
#define IPMI_CMD_MSI_ENABLE_SERIAL_PORT_SHARING     0x01
#define IPMI_CMD_MSI_ENABLE_SERIAL_PORT_SHARING2    0x02
#define IPMI_CMD_MSI_WRITE_BMC_DEFAULT_CONFIG       0x03
#define IPMI_CMD_MSI_SET_DEV_GUID                   0x04
#define IPMI_CMD_MSI_SET_CPU_INFO                   0x05
#define IPMI_CMD_MSI_DIMM_FAULT                     0x06
#define IPMI_CMD_MSI_SET_SYSTEM_INFO                0x07
#define IPMI_CMD_MSI_GET_SMI_REQUEST                0x08
#define IPMI_CMD_MSI_READ_SERIAL_PORT_STATUS        0x0d
#define IPMI_CMD_MSI_READY_FOR_HARDWARE_MONITOR     0x30
/* IPMI_NETFN_OEM_MSI2 */
#define IPMI_CMD_MSI_LED_CONTROL                    0x00
#define IPMI_CMD_MSI_GET_PWM_OF_FAN_SPEED_CONTROL   0x01
#define IPMI_CMD_MSI_SET_PWM_OF_FAN_SPEED_CONTROL   0x02

/*
 * AMD/OPMA OEM commands
 */

/* IPMI_NETFN_OEM_QLOGIC */
#define IPMI_CMD_QLOGIC_SET_SENSOR_READING_OFFSET   0x04
#define IPMI_CMD_QLOGIC_GET_SENSOR_READING_OFFSET   0x05
/* IPMI_NETFN_OEM_AMD */
#define IPMI_CMD_AMD_SET_SYSTEM_TYPE_IDENTIFIER	    0xA0
#define IPMI_CMD_AMD_GET_SYSTEM_TYPE_IDENTIFIER     0xA1
#define IPMI_CMD_AMD_GET_MCARD_CAPABILITIES	    0xA2
#define IPMI_CMD_AMD_CLEAR_CMOS			    0xA3
#define IPMI_CMD_AMD_SET_LOCAL_ACCESS_LOCKOUT_STATE 0xA4
#define IPMI_CMD_AMD_GET_LOCAL_ACCESS_LOCKOUT_STATE 0xA5
#define IPMI_CMD_AMD_GET_SUPPORTED_HOST_IDS	    0xA6

/*
 * ICP OEM command
 *
 * IPMI_NETFN_OEM_ICP
 */

#define IPMI_CMD_ICP_SET_CONFIG_PARAMETER           0x31
#define IPMI_CMD_ICP_GET_CONFIG_PARAMETER           0x32
#define IPMI_CMD_ICP_GET_CFU_SENSOR_VALUES          0x33
#define IPMI_CMD_ICP_GET_PSU_SENSOR_VALUES          0x34
#define IPMI_CMD_ICP_GET_IBSW_SENSOR_VALUES         0x35
#define IPMI_CMD_ICP_GET_CFU_STATUS_VALUES          0x36
#define IPMI_CMD_ICP_GET_PSU_STATUS_VALUES          0x37
#define IPMI_CMD_ICP_GET_IBSW_STATUS_VALUES         0x38
#define IPMI_CMD_ICP_SET_NODE_CONFIG_PARAMETERS     0x39
#define IPMI_CMD_ICP_GET_NODE_CONFIG_PARAMETERS     0x3a
#define IPMI_CMD_ICP_SET_NODE_POWER                 0x3b
#define IPMI_CMD_ICP_SET_NODE_RESET                 0x3c
#define IPMI_CMD_ICP_SET_NODE_BMC_RESET             0x3e
#define IPMI_CMD_ICP_SET_KVM_STATUS                 0x3f
#define IPMI_CMD_ICP_GET_KVM_STATUS                 0x40

/*
 * Peppercon OEM commands
 *
 * IPMI_NETFN_OEM_PP
 */
// PWM
#define IPMI_CMD_PP_GET_PWM_OF_FAN_SPEED_CONTROL    0x01
#define IPMI_CMD_PP_SET_PWM_OF_FAN_SPEED_CONTROL    0x02
// RPC
#define IPMI_CMD_PP_RPC_SET_POWER_ON_DELAY          0x10
#define IPMI_CMD_PP_RPC_GET_POWER_ON_DELAY          0x11
#define IPMI_CMD_PP_RPC_SET_RECEPTACLE_STATE        0x12
#define IPMI_CMD_PP_RPC_GET_RECEPTACLE_STATE        0x13
#define IPMI_CMD_PP_RPC_SET_GROUP_STATE             0x14
#define IPMI_CMD_PP_RPC_SET_GROUP_MEMBERSHIP        0x15
#define IPMI_CMD_PP_RPC_GET_GROUP_MEMBERSHIP        0x16
#define IPMI_CMD_PP_RPC_SET_GROUP_POWER_ON_DELAY    0x17
#define IPMI_CMD_PP_RPC_GET_GROUP_POWER_ON_DELAY    0x18
#define IPMI_CMD_PP_RPC_SET_RECEPTACLE_ACL          0x19
#define IPMI_CMD_PP_RPC_GET_RECEPTACLE_ACL          0x1a
// Firmware Upgrade
#define IPMI_CMD_PP_FIRMWARE_GET_VERSION            0x20
#define IPMI_CMD_PP_FIRMWARE_START_UPGRADE          0x21
#define IPMI_CMD_PP_FIRMWARE_UPLOAD                 0x22
#define IPMI_CMD_PP_FIRMWARE_FLASH                  0x23
#define IPMI_CMD_PP_FIRMWARE_CANCEL_UPGRADE         0x24
#define IPMI_CMD_PP_FIRMWARE_FINALIZE_UPGRADE       0x25
// Self-Test
#define IPMI_CMD_PP_PERFORM_SELFTEST                0x28
#define IPMI_CMD_PP_GET_SELFTEST_RESULT             0x29
// Config System
#define IPMI_CMD_PP_CONFIG_GET                      0x30
#define IPMI_CMD_PP_CONFIG_SET                      0x31
#define IPMI_CMD_PP_START_CONFIG_BACKUP             0x32
#define IPMI_CMD_PP_BACKUP_CONFIG                   0x33
#define IPMI_CMD_PP_FINISH_CONFIG_BACKUP            0x34
#define IPMI_CMD_PP_START_CONFIG_RESTORE            0x35
#define IPMI_CMD_PP_RESTORE_CONFIG                  0x36
#define IPMI_CMD_PP_FINISH_CONFIG_RESTORE           0x37
#define IPMI_CMD_PP_FNI_CONFIG                      0x38
// Miscellaneous
#define IPMI_CMD_PP_RESET_TO_FACTORY_DEFAULTS       0x40
#define IPMI_CMD_PP_GET_SERIAL_NUMBER               0x41
#define IPMI_CMD_PP_SET_SERIAL_NUMBER               0x42
// (User) management
#define IPMI_CMD_PP_SET_EXTENDED_USER_PARAMETERS    0x48
#define IPMI_CMD_PP_GET_EXTENDED_USER_PARAMETERS    0x49
// Virtual Media Management
#define IPMI_CMD_PP_GET_VIRTUAL_MEDIA_STATUS        0x50
#define IPMI_CMD_PP_CLOSE_VIRTUAL_MEDIA_SESSION     0x51
#define IPMI_CMD_PP_START_FLOPPY_IMAGE_UPLOAD       0x52
#define IPMI_CMD_PP_UPLOAD_FLOPPY_IMAGE             0x53
#define IPMI_CMD_PP_FINALIZE_FLOPPY_IMAGE_UPLOAD    0x54
#define IPMI_CMD_PP_START_SMB_IMAGE_MOUNT           0x55
#define IPMI_CMD_PP_SET_SMB_IMAGE_PARAMETER         0x56
#define IPMI_CMD_PP_FINALIZE_SMB_IMAGE_MOUNT        0x57

/*
 * Supermicro OEM commands added by Edward Pan, 3/30/06
 */
#define IPMI_CMD_SUPERMICRO_SMB_RELEASE	            0x02
#define IPMI_CMD_SUPERMICRO_CLEAR_CHASSIS_INTRUSION 0x03
#define IPMI_CMD_SUPERMICRO_GRACEFUL_POWER          0x04
#define IPMI_CMD_SUPERMICRO_SMB_REQUEST             0x05
#define IPMI_CMD_SUPERMICRO_WRITE_FRU_CAP           0x06
#define IPMI_CMD_SUPERMICRO_SMB_STATUS              0x07
#define IPMI_CMD_SUPERMICRO_GET_CHASSIS_STATUS      0x0f
#define IPMI_CMD_SUPERMICRO_SET_HW_INFO             0x20
#define IPMI_CMD_SUPERMICRO_GET_HW_INFO             0x21 


/*
 * Other stuff
 */

#define IPMI_ERASE_INITIATE     0xaa
#define IPMI_ERASE_GET_STATE    0x00
#define IPMI_ERASE_MAGIC        0x524c43 /* "CLR" */

#endif /* !__IPMI_CMD_H__ */
