/**
 * ipmi_sess.h
 *
 * Description: IPMI Sessions
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __IPMI_SESS_H__
#define __IPMI_SESS_H__

/* Privilege levels */ 
#define IPMI_PRIV_UNSPEC   0x0    // no session, no privilege, unactivated sessions or sessionless messages
#define IPMI_PRIV_CALLBACK 0x1    // allows users to initiate a callback session
#define IPMI_PRIV_USER     0x2    // allows sensor readings
#define IPMI_PRIV_OPERATOR 0x3    // allows partial configurations and hardware access
#define IPMI_PRIV_ADMIN    0x4    // allows full user/bmc configuration and hardware access
#define IPMI_PRIV_OEM      0x5    // unless specified otherwise: same as admin

/* v1.5 authtypes */
#define IPMI_AUTH_NONE     0x0
#define IPMI_AUTH_MD2      0x1
#define IPMI_AUTH_MD5      0x2
#define IPMI_AUTH_STRAIGHT 0x4
#define IPMI_AUTH_OEM      0x5
#define IPMI_AUTH_RMCPP    0x6

/* v2.0 authentication ciphersuites */
#define IPMI20_AUTH_NONE       0x00
#define IPMI20_AUTH_HMAC_SHA1  0x01
#define IPMI20_AUTH_HMAC_MD5   0x02
#define IPMI20_AUTH_ANY        0xFF   // used for ciphersuite selection only

/* v2.0 integrity ciphersuites */
#define IPMI20_INTEGRITY_NONE            0x00
#define IPMI20_INTEGRITY_HMAC_SHA1_96    0x01
#define IPMI20_INTEGRITY_HMAC_MD5_128    0x02
#define IPMI20_INTEGRITY_MD5_128         0x03
#define IPMI20_INTEGRITY_ANY             0xFF   // used for ciphersuite selection only

/* v2.0 confidentiality ciphersuites */
#define IPMI20_CONF_NONE          0x00
#define IPMI20_CONF_AES_CBC_128   0x01
#define IPMI20_CONF_XRC4_128      0x02
#define IPMI20_CONF_XRC4_40       0x03
#define IPMI20_CONF_ANY           0xFF   // used for ciphersuite selection only

/* v2.0 payload types */
#define IPMI_PAYLOAD_IPMI                       0x00
#define IPMI_PAYLOAD_SOL                        0x01
#define IPMI_PAYLOAD_OEM                        0x02
#define IPMI_PAYLOAD_RAKP_OPEN_SESSION_REQUEST  0x10
#define IPMI_PAYLOAD_RAKP_OPEN_SESSION_RESPONSE 0x11
#define IPMI_PAYLOAD_RAKP_MESSAGE1              0x12
#define IPMI_PAYLOAD_RAKP_MESSAGE2              0x13
#define IPMI_PAYLOAD_RAKP_MESSAGE3              0x14
#define IPMI_PAYLOAD_RAKP_MESSAGE4              0x15

/* RMCP+ and RAKP Message Status Codes */
#define IPMI_RAKP_STAT_NO_ERROR                 0x00
#define IPMI_RAKP_STAT_INSUF_RES                0x01
#define IPMI_RAKP_STAT_INVAL_SESS_ID            0x02
#define IPMI_RAKP_STAT_INVAL_PAYL_TYPE          0x03
#define IPMI_RAKP_STAT_INVAL_AUTH_ALGO          0x04
#define IPMI_RAKP_STAT_INVAL_INT_ALGO           0x05
#define IPMI_RAKP_STAT_NO_MATCHING_AUTH_PAYL    0x06
#define IPMI_RAKP_STAT_NO_MATCHING_INT_PAYL     0x07
#define IPMI_RAKP_STAT_INACTIVE_SESS_ID         0x08
#define IPMI_RAKP_STAT_INVAL_ROLE               0x09
#define IPMI_RAKP_STAT_UNAUTH_ROLE_OR_PRIV      0x0a
#define IPMI_RAKP_STAT_INSUF_RES_FOR_ROLE       0x0b
#define IPMI_RAKP_STAT_INVAL_NAME_LEN           0x0c
#define IPMI_RAKP_STAT_UNAUTH_NAME              0x0d
#define IPMI_RAKP_STAT_UNAUTH_GUID              0x0e
#define IPMI_RAKP_STAT_INVAL_INT_CHK_VAL        0x0f
#define IPMI_RAKP_STAT_INVAL_CONF_ALGO          0x10
#define IPMI_RAKP_STAT_NO_MATCHING_CIPHER       0x11
#define IPMI_RAKP_STAT_INVALID_PARAM            0x12

#endif /* !__IPMI_SESS_H__ */
