/**
 * host_graceful_ops.h
 *
 * Implements Supermicro's graceful power OEM commands.
 * (done by help of OS agent)
 *
 * (c) 2006 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef _PP_BMC_HARDWARE_GRACEFUL_OPS_H
#define _PP_BMC_HARDWARE_GRACEFUL_OPS_H

/**
 * Init the host_graceful_ops module, called by bmc_host_hardware_init()
 */
int pp_bmc_host_graceful_ops_init(void);

/**
 * Cleanup the host_graceful_ops module, called by bmc_host_hardware_cleanup()
 */
void pp_bmc_host_graceful_ops_cleanup(void);

/**
 * Cleanup the host_graceful_ops module, called by bmc_host_hardware_cleanup()
 * @param op Power operation to be done gracefully (HOST_POWER_CONTROL_...)
 * @returns PP_SUC if operation completed successful
 * @returns PP_ERR on error
 */
int pp_bmc_host_graceful_ops_execute(int op, int chan);

#endif /* _PP_BMC_HARDWARE_GRACEFUL_OPS_H */
