/**
 * lan_cipher_suites.h
 *
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 *
 * Implemented IPMIv20 ciphersuites
 */

struct pp_cipher_suite_record {
    // type = b11 (start of record)
    BITFIELD2(unsigned char,
        cipher_suite_type: 6,
        type_tag_bits: 2);
    unsigned char cipher_suite_id;
    
    // type = b00 (authentication algorithm number)
    BITFIELD2(unsigned char,
        auth_algorithm:6,
        auth_tag_bits:2);
    
    // type = b01 (integrity algorithm number)
    BITFIELD2(unsigned char,
        int_algorithm:6,
        int_tag_bits:2);
    
    // type = b10 (confidentiality algorithm number)
    BITFIELD2(unsigned char,
        conf_algorithm:6,
        conf_tag_bits:2);
        
} __attribute__ ((packed));
typedef struct pp_cipher_suite_record pp_cipher_suite_record_t;

#define PP_BMC_LAN_CIPHER_SUITE_COUNT 9

/* PP_BMC_LAN_CIPHER_SUITE_COUNT implemented cipher suite entries */
extern pp_cipher_suite_record_t *pp_bmc_lan_enabled_cipher_suites;

