/**
 * lan_sol.h
 *
 * Serial over LAN implementation
 * 
 * (c) 2004 Peppercon AG, 2005/4/29, tbr@peppecon.de
 */

#ifndef __BMC_SOL_H__
#define __BMC_SOL_H__

#include <pp/base.h>
#include <pp/bmc/lan_serv.h>

/*
 * Is the SOL activated or not?
 */
int pp_bmc_sol_state_is_active(void);

/*
 * If there is a SOL session, return the session id. Else return 0.
 */
int pp_bmc_sol_get_session_id(void);

/*
 * If there is a SOL session, return the port number of the
 * client. Else return 0.
 */
short pp_bmc_sol_get_remote_port(void);

/*
 * tries to activate an sol session
 * in case of error PP_ERR will be returned and
 * ipmi_rs_code will contain sol-payload specific response codes
 */
int pp_bmc_sol_activate(unsigned char* ipmi_rs_code, 
			unsigned short* max_inbound_size,
			unsigned short* max_outbound_size,
			imsg_session_t* session);

/*
 * deactives an active sol session
 * in case of error ipmi_rs_code will contain an sol-payload
 * specific response code
 */
int pp_bmc_sol_deactivate(unsigned char* ipmi_rs_code,
			  imsg_session_t* session);

/*
 * some config keys used by sol implementation
 */
extern const char* PP_BMC_SOL_CFG_IS_ENABLED;
extern const char* PP_BMC_SOL_CFG_ACCU_INTERVAL;
extern const char* PP_BMC_SOL_CFG_SEND_TRESHOLD;
extern const char* PP_BMC_SOL_CFG_RETRY_CNT;
extern const char* PP_BMC_SOL_CFG_RETRY_INTERVAL;
extern const char* PP_BMC_SOL_CFG_TTY_SPEED;

/*
 * gets/sets volatile sol parameters
 */
int pp_bmc_sol_get_tty_speed(void);
int pp_bmc_sol_set_tty_speed(int ttyspeed);

/*
 * Initialize sol serial handler
 */
void pp_sol_cleanup(void);
    
/*
 * Cleanup sol serial handler
 */
int pp_sol_init(void);

#endif /* __BMC_SOL_H__ */
