/**
 * loopi_adapter.c
 *
 * (c) 2005 Peppercon AG, 2005/2/24, tbr@peppecon.de
 *
 * This is a local loop interface that can be used to access the BMC
 * from within the erla. It is based on named pipes and currently
 * offers to pairs of pipes, one for communication within the eric
 * process, one for communication with the snmp daemon.
 */

#ifndef _PP_BMC_LOOPI_ADAPTER_H
#define _PP_BMC_LOOPI_ADAPTER_H

#define PP_BMC_LOOPI_ERIC     0
#define PP_BMC_LOOPI_SNMPD    1
#define PP_BMC_LOOPI_BAYTECH  2
#define PP_BMC_LOOPI_MAX      3 /* pls. do adjust when adding channels */

/** 
 * Init the loopi channel adapter
 */
void pp_bmc_loopi_cleanup(int loopi_chan);

/** 
 * Cleanup the loopi channel adapter
 */
int pp_bmc_loopi_init(int loopi_chan);

#endif /* _PP_BMC_LOOPI_ADAPTER_H */
