/**
 * adc_kira_sensor.h
 *
 * KIRA ADC sensors
 * 
 * (c) 2006 Peppercon AG, mkl@peppecon.de
 */

#ifndef __ADC_KIRA_SENSOR_H
#define __ADC_KIRA_SENSOR_H

#include <pp/bmc/topo_base_obj.h>

/* ppdoc: 
 * name:   ADC KIRA sensor
 * tpname: ADCKIRASens
 * desc:   ADC KIRA sensor chip. Sensor channels are accessed directly with a device driver.
 * arg 1:  [INT] sensor_no:            sensor number
 * arg 1:                              0-7: voltage sensor (channel)
 * arg 2:  [INT] cfactor:              correction factor
 * arg 3:  [OBJ(COND)] scan_cond:      (optional) power condition. Sensor
 * arg 3:                              won't be scanned if condition is false
 * return: [OBJ(SENS_DEV)]
 */
pp_tp_obj_t* pp_sensor_adc_kira_ctor(const char* id, vector_t* args);

#endif /* __ADC_KIRA_SENSOR_H */
