/**
 * 
 */

#include <pp/base.h>
#include <pp/bmc/tp_i2c_chip.h>

typedef struct {
    /* chip superobject */
    pp_tp_i2c_chip_t base;
    
    /* our internal state */
    char adt_state;
    
    /* initial poweron delay - timeout handle */
    int init_to_hndl;

} pp_tp_adt7463_chip_t;


/* ppdoc
 * name:   ADT7463 chip
 * tpname: ADT7463_chip
 * desc:   ADT7463 chip object, needed by ADT7463 sensors and pwms.
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev: i2c device to be used
 * arg 1:  [INT] i2c_addr:            i2c slave address of this device
 * arg 2:  [OBJ(COND)] powercond:     power on condition (chip will be
 * arg 2:                             initialized if condition changes to on,
 * arg 2:                             sensors won't be read while cond is false)
 * return: [OBJ(I2C_CHIP)]
 */
pp_tp_obj_t* pp_adt7463_chip_ctor(const char* id, vector_t* args);

/**
 * Check if adt7463 is ready for monitoring. Must be applied in 
 * addition to do_scan and existing sensor conditions.
 */
int pp_tp_adt7463_chip_is_ready(pp_tp_i2c_chip_t* this);

