/**
 * lm94.c
 *
 * implements the lm94 chip object
 * 
 * (c) 2006 Peppercon AG, 2006/03/24, rgue@peppercon.de
 */

#include <pp/selector.h>

#include <pp/bmc/debug.h>
#include <pp/bmc/topo_factory.h>

#include "drivers/lm94.h"

/* internal prototypes */
static
pp_tp_obj_t* lm94_init(const unsigned char* id,
                       pp_tp_i2c_comdev_t* i2cdev,
                       unsigned char i2caddr,
                       pp_tp_cond_t* init_cond,
                       unsigned char *fan_ppr);
static void pp_tp_lm94_cleanup(pp_tp_lm94_t* this);
static void power_on_init(pp_tp_lm94_t* this);
static void power_off_cleanup(pp_tp_lm94_t* this);


pp_tp_obj_t* pp_lm94_ctor(const char* id, vector_t* args) {
    pp_strstream_t err = PP_STRSTREAM_INITIALIZER;

    pp_tp_i2c_comdev_t* i2cdev;
    int i2caddr;
    pp_tp_cond_t* init_cond;
    unsigned char fan_ppr[4];
      
    if (pp_tp_arg_scanf(args, 0, &err, "o<i>do<sc>d<c>d<c>d<c>d<c>",
                        &i2cdev, &i2caddr, &init_cond,
                        &fan_ppr[0], &fan_ppr[1], &fan_ppr[2], &fan_ppr[3]) != 7)
    {
        pp_bmc_log_error("'%s' failed: %s (%s)",
                        id, strerror(errno), pp_strstream_buf(&err));
        return NULL;
    }
    
    return lm94_init(id, i2cdev, i2caddr, init_cond, fan_ppr);
}

static
pp_tp_obj_t* lm94_init(const unsigned char* id,
                       pp_tp_i2c_comdev_t* i2cdev,
                       unsigned char i2caddr,
                       pp_tp_cond_t* init_cond,
                       unsigned char *fan_ppr)
{   
    pp_tp_lm94_t* this;

    this = malloc(sizeof(pp_tp_lm94_t));
    memset(this, 0, sizeof(pp_tp_lm94_t));
    
    pp_tp_i2c_chip_init((pp_tp_i2c_chip_t*)this, PP_TP_I2C_CHIP,
                        id, (void*)pp_tp_lm94_cleanup,
                        "lm94", i2cdev, 
                        i2caddr, init_cond,
                        (void*)power_on_init,
                        (void*)power_off_cleanup);

    memcpy(this->fan_pulse_per_revol, fan_ppr, sizeof(this->fan_pulse_per_revol));

    pp_bmc_log_info("[LM94] '%s' initialized", id);
    
    return (pp_tp_obj_t*)this;
}

static void pp_tp_lm94_cleanup(pp_tp_lm94_t* this) {
    pp_bmc_log_info("[LM94] cleaning up chip '%s'", ((pp_tp_obj_t*)this)->id);

    pp_tp_i2c_chip_cleanup((pp_tp_i2c_chip_t*) this);

    free (this);
}

// called on chip_poweron
static void power_on_init(pp_tp_lm94_t* this UNUSED) {
    pp_bmc_log_debug("[LM94] power_on_init");
}

static void power_off_cleanup(pp_tp_lm94_t* this UNUSED) {
    pp_bmc_log_debug("[LM94] power_off");
}
