/**
 * pp_i2c_mux_pca9548.h
 *
 * A concrete implementation for the Philips PCA9548 i2c multiplexer
 * 
 * (c) 2005 Peppercon AG, 6/14/2005, miba@peppercon.de
 */

#ifndef __TP_PP_I2C_MUX_9548_H__
#define __TP_PP_I2C_MUX_9548_H__

#include <pp/vector.h>
#include <pp/bmc/tp_i2c_mux.h>

typedef struct pp_i2c_mux_pca9548_s {
    pp_tp_i2c_mux_t base;
} pp_i2c_mux_pca9548_t;

void pp_i2c_mux_pca9548_init(pp_i2c_mux_pca9548_t* d,
			     const char * id,
			     pp_tp_i2c_comdev_t* parent,
			     u_char i2caddr,
			     u_char channel);

static inline void pp_i2c_mux_pca9548_cleanup(pp_tp_obj_t* d) {
    pp_tp_i2c_mux_cleanup((pp_tp_i2c_mux_t*)d);
}

/* ppdoc
 * name:   I2C multiplexer PCA9548
 * tpname: I2CMux9548
 * desc:   Philips PCA9548 i2c multiplexer, can be used to address one
 * desc:   branch of the 9548 as i2c communication device (I2C_DEV).
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev: i2c master device the mux is connected to
 * arg 1:  [INT] i2c_addr:            i2c slave address of this mux
 * arg 2:  [INT] channel:             downstream channel number of this mux
 * return: [OBJ(I2C_MUX)]
 */
pp_tp_obj_t* pp_i2c_mux_pca9548_ctor (const char* id, vector_t* args);

/**
 * Destroy method
 */
void pp_i2c_mux_pca9548_dtor (pp_tp_obj_t* d);

#endif
