/**
 * pp_pca9555_gpio_dev.h
 *
 * Device driver class for the Philips PCA9555 I2C GPIO Extender
 * 
 * (c) 2005 Peppercon AG, Michael Baumann <miba@peppercon.de>
 */

 
#ifndef __PP_BMC_PCA9555_GPIO_DEVICE_H__
#define __PP_BMC_PCA9555_GPIO_DEVICE_H__

#include <pp/bmc/tp_i2c_comdev.h>
#include <pp/bmc/tp_gpio_dev.h>

#include "pca955x_gpio_dev.h"

/**
 * concrete device for PCA9555 extender
 */
typedef struct pp_pca9555_gpio_dev_s {
    pp_pca955x_gpio_dev_t base;
} pp_pca9555_gpio_dev_t;


/**
 * device initializer
 * @returns PP_ERR if the initialization failed
 */
int pp_pca9555_gpio_dev_init(pp_pca9555_gpio_dev_t* d,
			     pp_tp_i2c_comdev_t* i2cdev,
			     u_char i2caddr, pp_tp_cond_t* pres_cond);

/* ppdoc
 * name:   Philips PCA9555 i2c gpio expander
 * tpname: PCA9555Gpio
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev: i2c device the extender is connected to
 * arg 1:  [INT] i2caddr:             i2c slave address of this extender
 * arg 2:  [OBJ(COND)] presence:      (optional) presence (power on) condition
 * return: [OBJ(GPIO_DEV)]
 */
pp_tp_obj_t* pp_pca9555_gpio_dev_ctor(const char* id, vector_t* args);

#endif
