/**
 * pp_powersupply_sens.h
 *
 * Discrete sensor for power supply monitoring. Combines several gpio
 * readings in one IPMI-conformant discrete 'power supply' reading
 * (see table 42.2) Currently made for the AMD Warthog board,
 * to be extended when necessary.
 * 
 * (c) 2005 Peppercon AG, Michael Baumann <miba@peppercon.de>
 */

#ifndef __PP_BMC_POWERSUPPLY_SENS_H__
#define __PP_BMC_POWERSUPPLY_SENS_H__

#include <pp/bmc/tp_sensdev.h>
#include <pp/bmc/tp_gpio_sens.h>

typedef struct pp_tp_powersupply_sens_s {
    pp_tp_sensdev_t base;

    /* GPIO sensors for status detection */
    pp_tp_gpio_sens_t* gpio_presence;
    pp_tp_gpio_sens_t* gpio_fault;
    pp_tp_gpio_sens_t* gpio_input;
    
    pp_tp_sensdev_subscriber_t sens_subscr;
} pp_powersupply_sens_t;


/* ppdoc
 * name:   Powersupply sensor
 * tpname: PowersupplySens
 * desc:   A sensor that combines several GPIOs into one reading that can
 * desc:   be used to create a discrete IPMI 'powersupply' sensor (see spec
 * desc:   table 42-2)
 * arg 0:  [OBJ(GPIO_SENS)] presence: gpio sensor for presence_status (1=present)
 * arg 1:  [OBJ(GPIO_SENS)] fault:    gpio sensor for fault status (1=faulty)
 * arg 2:  [OBJ(GPIO_SENS)] ac_ok:    gpio sensor for ac input status (1=ac ok)
 * return: [OBJ(GPIO_SENS)]
 */
pp_tp_obj_t* pp_powersupply_sens_ctor(const char* id, vector_t* args);

void pp_powersupply_sens_init(pp_powersupply_sens_t* this,
			      const char *id,
			      pp_tp_gpio_sens_t* gpio_presence,
			      pp_tp_gpio_sens_t* gpio_fault,
			      pp_tp_gpio_sens_t* gpio_input);

static inline int pp_powersupply_sens_get_reading(pp_powersupply_sens_t* t) {
    return pp_tp_sensdev_get_reading(&t->base);
}

#endif /* PP_BMC_POWERSUPPLY_SENS */
