/**
 * smi_smx.c
 *
 * Serial Mux object for Supermicro
 * 
 * (c) 2006 Peppercon AG, 2006/04/05 rgue@peppercon.de
 */

#include <pp/base.h>
#include <lara.h>
#include <pp/bmc/debug.h>
#include <pp/bmc/topo_factory.h>
#include <pp/bmc/tp_gpio_dev.h>
#include <pp/bmc/tp_smx_act.h>
#include "smi_smx.h"

typedef struct smi_smx_s {
    pp_tp_smx_act_t base;
    pp_tp_gpio_dev_t* gpio_dev;
    unsigned char gpio_pin;
} smi_smx_t;

static const char* cname = "[SmiSmx]";

static int smi_smx_switch_host_chassis(pp_tp_smx_act_t* o) {
    smi_smx_t* this = (smi_smx_t*)o;
    pp_bmc_log_debug("%s switching S-Mux to host-chassis", cname);
    pp_tp_gpio_dev_set_gpio(this->gpio_dev, this->gpio_pin, 'z'); // SMUX inactive
    return PP_SUC;
}

static int smi_smx_switch_bmc_chassis(pp_tp_smx_act_t* o UNUSED) {
    //smi_smx_t* this = (smi_smx_t*)o;
    pp_bmc_log_debug("%s switching S-Mux to bmc-chassis - not supported", cname);
    return PP_ERR; // this connection not supported by mainboard
}

static int smi_smx_switch_host_bmc(pp_tp_smx_act_t* o) {
    smi_smx_t* this = (smi_smx_t*)o;
    pp_bmc_log_debug("%s switching S-Mux to host-bmc", cname);
    pp_tp_gpio_dev_set_gpio(this->gpio_dev, this->gpio_pin, 0); // SMUX low active
    return PP_SUC;
}

static void smi_smx_dtor(pp_tp_obj_t* o) {
    if (o != NULL) {
	assert(PP_TP_OBJ_IS_TYPE(PP_TP_SMX_ACT, o));
	smi_smx_t* this = (smi_smx_t*)o;
	pp_tp_gpio_dev_release(this->gpio_dev);
	pp_tp_smx_act_cleanup(&this->base);
	free(this);
    }
}

pp_tp_obj_t* pp_smi_smx_ctor (const char* id, vector_t* args) {
    pp_strstream_t err = PP_STRSTREAM_INITIALIZER;
    pp_tp_gpio_dev_t* gpio_dev;
    unsigned char pin;
    smi_smx_t* this = NULL;

    if (pp_tp_arg_scanf(args, 0, &err, "o<g>d<c>", &gpio_dev, &pin) != 2) {
	pp_bmc_log_error("%s (%s) failed: %s", cname, id,
			 pp_strstream_buf(&err));
    } else {
	this = malloc(sizeof(smi_smx_t));
	pp_tp_smx_act_init(&this->base, PP_TP_SMX_ACT, id, smi_smx_dtor,
			   smi_smx_switch_host_chassis,
			   smi_smx_switch_bmc_chassis,
			   smi_smx_switch_host_bmc);
	this->gpio_dev = pp_tp_gpio_dev_duplicate(gpio_dev);
	this->gpio_pin = pin;

	pp_tp_gpio_dev_init_gpio(this->gpio_dev, 1 << this->gpio_pin);
    }
    pp_strstream_free(&err);
    return (pp_tp_obj_t*)this;
}
