/**
 * w83791d.h
 *
 * implements the w83791d chip object
 * 
 * (c) 2005 Peppercon AG, 2005/11/7, thomas@peppercon.de
 */

#ifndef __PP_SENSOR_W83791D_H__
#define __PP_SENSOR_W83791D_H__

#include <pp/bmc/topo_base_obj.h>
#include <pp/bmc/tp_i2c_chip.h>

typedef struct pp_tp_w83791d_chip_s {
    pp_tp_i2c_chip_t base;
    unsigned short gpio_mask;
    unsigned short gpio_io_mask;
    unsigned char pwm_pre_scale;
} pp_tp_w83791d_chip_t;


/* ppdoc
 * name:   W83791d chip
 * tpname: W83791D
 * desc:   Common object for all w83791 sensors, pwms and gpios.
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev: i2c device to be used
 * arg 1:  [INT] i2c_addr:            i2c slave address of this device
 * arg 2:  [OBJ(COND)] powercond:     power on condition (chip will be
 * arg 2:                             initialized if condition changes to on,
 * arg 2:                             sensors won't be read while cond is false)
 * arg 3:  [INT] gpio_mask:           GPIO mask, 12 bit, 1 enables according GPIO
 * arg 4:  [INT] gpio_dir:            GPIO in/out mask, 12 bit, 1 marks GPIO as output
 * arg 5:  [INT] pwm_prescaler:       PWM Pre Scale Register, 8bit as per Spec,
 * arg 5:                             currently identical for all 5 PWMs,
 * arg 5:                             will be written to 0x80, 0x82, 0x93, 0xA0, 0xA1
 * return: [OBJ(I2C_CHIP)]
 */
pp_tp_obj_t* pp_sensor_w83791d_ctor(const char* id, vector_t* args);

#define W83791D_MODEL_STRING "w83791d"

#define W83791D_PWM_MAX_NUMBER 5

/* some register symbols, as per spec W83791D.pf */
#define W83791D_GPIO_CONTROL_REG_1        0x13
#define W83791D_GPIO_DATA_STATUS_REG_1    0x14
#define W83791D_GPIO_CONTROL_REG_2        0x15
#define W83791D_GPIO_DATA_STATUS_REG_2    0x16
#define W83791D_DIODE_SELECTION_REG       0x59
#define W83791D_VBAT_MONITOR_CONTROL_REG  0x5D
#define W83791D_PWM_PRE_SCALE_REG_FAN_1   0x80
#define W83791D_PWM_DUTY_CYCLE_REG_FAN_1  0x81
#define W83791D_PWM_PRE_SCALE_REG_FAN_2   0x82
#define W83791D_PWM_DUTY_CYCLE_REG_FAN_2  0x83
#define W83791D_PWM_PRE_SCALE_REG_FAN_3   0x93
#define W83791D_PWM_DUTY_CYCLE_REG_FAN_3  0x94
#define W83791D_PWM_PRE_SCALE_REG_FAN_4   0x9E
#define W83791D_PWM_PRE_SCALE_REG_FAN_5   0x9F
#define W83791D_PWM_DUTY_CYCLE_REG_FAN_4  0xA0
#define W83791D_PWM_DUTY_CYCLE_REG_FAN_5  0xA1

#endif /* __PP_SENSOR_W83791D_H__ */
