/**
 * w83792d_clr_intrusion.h
 *
 * implements W83791D gpio device
 * 
 * (c) 2006 Peppercon AG, 2006/04/30, rgue@peppercon.de
 */

#ifndef __W83792D_CLR_INTRUSION_H__
#define __W83792D_CLR_INTRUSION_H__

#include <pp/base.h>


/* ppdoc
 * name:   W83791d Clear Chassis Intrusion Device
 * tpname: W83791DClrIntrusion
 * desc:   A device to clear the chassis intrusion bit on the W83792d chip.
 *         Just use a GpioAct at pin 0. Setting 1 (auto resets) clears intrusion bit. 
 * arg 0:  [OBJ(I2C_CHIP)] chip: i2c chip, must be a W83792D
 * return: [OBJ(GPIO_DEV)]
 */
pp_tp_obj_t* pp_sensor_w83792d_clr_intrusion_ctor(const char* id, vector_t* args);

#endif
