/**
 * w83793g_sensor.h
 *
 * "Super class" for all Winbond W83793G sensors
 * 
 * (c) 2006 Supermicro, 2006/04/04, Edward Pan<edwardp@supermicro.com>
 */

#ifndef __W83793G_SENSOR_H
#define __W83793G_SENSOR_H

#include <pp/bmc/topo_base_obj.h>

/* ppdoc
 * name:   W83793G sensor
 * tpname: W83793G
 * desc:   A sensor object for the w83793 chip. Dessolves to different sensors
 * desc:   depending on the arguments.
 * arg 0:  [OBJ(I2C_CHIP)] chip: i2c chip, must be an W83793g
 * arg 1:  [INT] sensor_no:      sensor number within the chip, whereas:
 * arg 1:                         0: VcoreA
 * arg 1:                         1: VcoreB
 * arg 1:                         2: Volt (-12V)
 * arg 1:                         3: Volt (1.5V)
 * arg 1:                         4: Volt (3.3V)
 * arg 1:                         5: Volt (+12V)
 * arg 1:                         6: 5VCC
 * arg 1:                         7: VSB
 * arg 1:                         8: VBAT
 * arg 1:                         9: FAN1
 * arg 1:                        10: FAN2
 * arg 1:                        11: FAN3
 * arg 1:                        12: FAN4
 * arg 1:                        13: FAN5
 * arg 1:                        14: FAN6
 * arg 1:                        15: FAN7
 * arg 1:                        16: FAN8
 * arg 1:                        17: FAN9
 * arg 1:                        18: FAN10
 * arg 1:                        19: Temp-CPU1-CoreA
 * arg 1:                        20: Temp-CPU1-CoreB
 * arg 1:                        21: Temp-CPU2-CoreA
 * arg 1:                        22: Temp-CPU2-CoreB
 * arg 1:                        23: Temp-Sys
 * arg 1:                        24: Chassis
 * arg 2: [OBJ(COND)] scan_cond: (optional) scan condition, sensors won't be
 * arg 2:                        read if condition is false
 * return: [OBJ(SENS_DEV)]
 */
pp_tp_obj_t* pp_sensor_w83793g_sens_ctor(const char* id, vector_t* args);

#define PP_SENSOR_W83793G_MAX_SENSOR_NUM 24

#endif /* __W83793G_SENSOR_H */
