/**
 * tp_acpi_power_state_gpio.h
 *
 * A concrete implementation of an ACPI power state sensor for
 * hardware that only has an on/off indicator (gpio).
 * 
 * (c) 2005 Peppercon AG, Ronald Wahl <rwa@peppercon.de>
 */

#ifndef _PP_BMC_ACPI_POWER_STATE_GPIO_H
#define _PP_BMC_ACPI_POWER_STATE_GPIO_H

#include <pp/vector.h>
#include <pp/bmc/tp_gpio_sens.h>
#include <pp/bmc/tp_acpi_power_state.h>

typedef struct {
    pp_tp_acpi_power_state_t base;
    pp_tp_gpio_sens_t * acpi_state_gpio;
    pp_tp_sensdev_subscriber_t gpio_subscriber;
} pp_tp_acpi_power_state_gpio_t;

/* ppdoc
 * name:   GPIO based Acpi power state sensor
 * tpname: AcpiPowerStateGpio
 * desc:   ACPI PowerState sensor that knows only two power states 'on' and 'off'.
 * desc:   These power states are directly taken from a GPIO sensor.
 * arg0:   [OBJ(GPIO_SENS)] power_gpio: 'power on' gpio sensor object
 * return: [OBJ(ACPI_POWER_STATE)]
 */
pp_tp_obj_t* pp_tp_acpi_power_state_gpio_ctor(const char* id, vector_t* args);

void pp_tp_acpi_power_state_gpio_dtor(pp_tp_obj_t* this);

int pp_tp_acpi_power_state_gpio_init(pp_tp_acpi_power_state_gpio_t* this,
				     pp_tp_obj_type_t type, const char* id,
				     pp_tp_obj_dtor_func_t dtor,
				     pp_tp_gpio_sens_t * acpi_state_gpio);

void pp_tp_acpi_power_state_gpio_cleanup(pp_tp_acpi_power_state_gpio_t* this);

#endif /* _PP_BMC_ACPI_POWER_STATE_GPIO_H */
