/**
 * tp_actor.h
 *
 * Abstract actor object
 * 
 * (c) 2005 Peppercon AG, 22/05/2005, tbr@peppecon.de
 */

#ifndef _PP_BMC_TP_ACTOR_H
#define _PP_BMC_TP_ACTOR_H

#include <pp/bmc/topo_base_obj.h>
#include <pp/bmc/tp_sens_subscriber.h>

/**
 * An actor is a tagging object class only,
 * so we simply define some inline methods for convenience
 */

typedef pp_tp_obj_t pp_tp_actor_t;

static inline int
pp_tp_actor_init(pp_tp_actor_t* this, pp_tp_obj_type_t type, 
		 const char* id, pp_tp_obj_dtor_func_t dtor)
{
    return pp_tp_obj_init((pp_tp_obj_t*)this, type, id, dtor);
}

static inline void
pp_tp_actor_cleanup(pp_tp_actor_t* this)
{
    pp_tp_obj_cleanup((pp_tp_obj_t*)this);
}

#endif /* _PP_BMC_TP_ACTOR_H */
