/**
 * tp_delayed_cond.h
 *
 * delays the change of a condition reading by
 * the specified amount of time
 * 
 * (c) 2005 Peppercon AG, 2005/08/10, tbr@peppecon.de
 */

#ifndef _PP_BMC_TP_DELAYED_COND_H
#define _PP_BMC_TP_DELAYED_COND_H

#include <pp/bmc/tp_cond.h>

typedef struct pp_tp_delayed_cond_s pp_tp_delayed_cond_t;

/* ppdoc
 * name:   Delayed Condition
 * tpname: DelayedCond
 * desc:   Delays the assertion/deassertion of another (existing) condition by
 * desc:   a configurable amount of time.
 * arg0:   [OBJ(COND)] base_cond: the condition to delay
 * arg1:   [INT] atime: delay time for assertion events
 * arg2:   [INT] dtime: delay time for deassertion events
 * return: [OBJ(COND)]
 */
pp_tp_obj_t* pp_tp_delayed_cond_ctor(const char* id, vector_t* args);

static inline pp_tp_delayed_cond_t*
pp_tp_delayed_cond_duplicate(pp_tp_delayed_cond_t* this)
{
    return (pp_tp_delayed_cond_t*)pp_tp_obj_duplicate((pp_tp_obj_t*)this);
}

static inline void
pp_tp_delayed_cond_release(pp_tp_delayed_cond_t* this)
{
    pp_tp_obj_release((pp_tp_obj_t*)this);
}

#endif
