/**
 * tp_event_collect_ctrl.h
 *
 * Event collection controller, triggers an actor when one of its
 * ISensors asserts an event covered by its mask
 * 
 * (c) 2005 Peppercon AG, 19/07/2005, miba@peppercon.de
 */

#ifndef __PP_BMC_EVENT_COLLECT_CTRL_H__
#define __PP_BMC_EVENT_COLLECT_CTRL_H__

#include <pp/bmc/tp_ctrl.h>
#include <pp/bmc/tp_gpio_act.h>

typedef struct {
    pp_tp_ctrl_t base;

    pp_tp_gpio_act_t *act;
    vector_t *sensvec;
    
    u_long signals_pending;
    int output;
} pp_tp_event_collect_ctrl_t;


/* ppdoc
 * name:   Event collection controller
 * tpname: EventCollectCtrl
 * desc:   Asserts an actor depending on the event status of 
 * desc:   connected IPMI sensors. An assertion mask can be
 * desc:   assigned to each connected sensor. If any masked
 * desc:   condition of any connected sensor becomes true,
 * desc:   the actor is asserted. An additional condition
 * desc:   masking a complete sensor can be provided.
 * arg0:   [OBJ(GPIO_ACT)] act:     actor to set on event assertion
 * arg1:   [OBJ(IPMI_SENSOR)] sen1: ipmi sensor to query for events
 * arg2:   [INT] sen1_mask:         event assertion mask for the ipmi sensor
 * arg3:   [OBJ(COND)] sen1_cond:   condition for the ipmi sensor sen1 to be considered
 * arg3:                            for generating the actor assertion
 * arg4:   [...]                    (optional) args 1 to 3 can be repeated
 * arg4:                            to connect additional sensors to the
 * arg4:                            collection
 * return: [OBJ(CTRL)]
 */
pp_tp_obj_t* pp_tp_event_collect_ctrl_ctor(const char* id, vector_t* args);

void pp_tp_event_collect_ctrl_dtor(pp_tp_obj_t* this);

int pp_tp_event_collect_ctrl_init(pp_tp_event_collect_ctrl_t* this, pp_tp_obj_type_t type,
			       const char* id, pp_tp_obj_dtor_func_t dtor,
			       pp_tp_gpio_act_t *act, vector_t *sensvec);

void pp_tp_event_collect_ctrl_cleanup(pp_tp_event_collect_ctrl_t* this);

#endif /* __PP_BMC_EVENT_COLLECT_CTRL_H__ */
