/**
 * tp_event_collect_ctrl.h
 *
 * Event collection controller, triggers an actor when one of its
 * ISensors asserts an event covered by its mask
 * 
 * (c) 2005 Peppercon AG, 19/07/2005, miba@peppercon.de
 */

#ifndef _PP_BMC_EVENT_COLLECT_PWM_CTRL_H
#define _PP_BMC_EVENT_COLLECT_PWM_CTRL_H

#include <pp/bmc/tp_ctrl.h>
#include <pp/bmc/tp_pwm_act.h>

typedef struct {
    pp_tp_ctrl_t base;

    pp_tp_pwm_act_t *act;
    vector_t *sensvec;
    
    u_long signals_pending;
    u_char duty_cycle;
    u_char output;
} pp_tp_event_collect_pwm_ctrl_t;


/* ppdoc
 * name:   Event collection PWM controller
 * tpname: EventCollectPwmCtrl
 * desc:   Set the duty cycle of a specified PWM actor depending on the event
 * desc:   status of connected IPMI sensors. An assertion mask can be assigned
 * desc:   to each connected sensor. If any masked condition of any connected
 * desc:   sensor becomes true, the PWM's duty cycle is set to the according
 * desc:   controller parameter. An additional condition masking a complete
 * desc:   sensor can be provided.
 * arg0:   [OBJ(PWM_ACT)] act: PWM actor to set on event assertion
 * arg1:   [UCHAR] duty_cycle: duty cycle if no events in the mask are asserted
 * arg2:   [OBJ(IPMI_SENSOR)] sen1: ipmi sensor to query for events
 * arg3:   [INT] sen1_mask:         event assertion mask for the ipmi sensor
 * arg4:   [OBJ(COND)] sen1_cond:   condition for the ipmi sensor sen1 to be considered
 * arg4:                            for generating the actor assertion
 * arg5:   [...]                    (optional) args 2 to 4 can be repeated
 * arg5:                            to connect additional sensors to the
 * arg5:                            collection
 * return: [OBJ(CTRL)]
 */
pp_tp_obj_t* pp_tp_event_collect_pwm_ctrl_ctor(const char* id, vector_t* args);

void pp_tp_event_collect_pwm_ctrl_dtor(pp_tp_obj_t* this);

int pp_tp_event_collect_pwm_ctrl_init(pp_tp_event_collect_pwm_ctrl_t* this, pp_tp_obj_type_t type,
				      const char* id, pp_tp_obj_dtor_func_t dtor,
				      pp_tp_pwm_act_t *act, vector_t *sensvec, u_char duty_cycle);

void pp_tp_event_collect_pwm_ctrl_cleanup(pp_tp_event_collect_pwm_ctrl_t* this);

#endif /* _PP_BMC_EVENT_COLLECT_PWM_CTRL_H */
